package me.youm.core.webflux.config;

import io.swagger.models.auth.In;
import me.youm.core.common.constants.Oauth2Constant;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.*;
import springfox.documentation.oas.annotations.EnableOpenApi;
import springfox.documentation.service.*;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@EnableOpenApi
@Configuration
public class SwaggerConfiguration {

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.OAS_30)
                .select()
                .apis(RequestHandlerSelectors.basePackage("cn.crushes.dolly"))
                .paths(PathSelectors.any())
                .build()
                .globalRequestParameters(this.requestParameterList())
                .securitySchemes(securitySchemes()) //添加token
                .securityContexts(securityContexts()) //swagger配置页面访问是否需要传token
                .apiInfo(apiInfo());
    }

    /**
     * 统一设置请求参数
     */
    List<RequestParameter> requestParameterList() {
        RequestParameter headParameter = new RequestParameterBuilder()
                .in(ParameterType.HEADER)
                .name("Authorization")
                .description("Authorization")
                .required(false)
                .build();
        return Stream.of(headParameter).collect(Collectors.toList());
    }

    /**
     * 授权信息全局应用
     */
    private List<SecurityContext> securityContexts() {
        return Collections.singletonList(
                SecurityContext.builder()
                        .securityReferences(Collections.singletonList(new SecurityReference(Oauth2Constant.HEADER_TOKEN, new AuthorizationScope[]{new AuthorizationScope("global", "")})))
                        .build()
        );
    }

    /**
     * 设置授权信息
     */
    private List<SecurityScheme> securitySchemes() {
        ApiKey apiKey = new ApiKey(Oauth2Constant.HEADER_TOKEN, Oauth2Constant.HEADER_TOKEN, In.HEADER.toValue());
        return Collections.singletonList(apiKey);
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                .title("dolly接口文档")
                .description("服务端api接口文档")
                .contact(new Contact("youta","https://youm.me","youtaqiu@gmail.com"))
                .termsOfServiceUrl("https://crackydolly.com/api")
                .version("1.0.0")
                .build();
    }

}
