/*
 * Decompiled with CFR 0.152.
 */
package me.youm.core.webflux.handler;

import java.util.Map;
import javax.annotation.Resource;
import me.youm.core.common.exception.TokenException;
import me.youm.core.webflux.handler.ExceptionHandlerAdvice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.DefaultErrorWebExceptionHandler;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@Component
public class GlobalErrorWebExceptionHandler
extends DefaultErrorWebExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalErrorWebExceptionHandler.class);
    @Resource
    private ExceptionHandlerAdvice exceptionHandlerAdvice;

    public GlobalErrorWebExceptionHandler(ErrorAttributes errorAttributes, WebProperties.Resources resources, ErrorProperties errorProperties, ApplicationContext applicationContext) {
        super(errorAttributes, resources, errorProperties, applicationContext);
    }

    protected RouterFunction<ServerResponse> getRoutingFunction(ErrorAttributes errorAttributes) {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.all(), this::renderErrorResponse);
    }

    protected Mono<ServerResponse> renderErrorResponse(ServerRequest request) {
        Map error = this.getErrorAttributes(request, this.getErrorAttributeOptions(request, MediaType.ALL));
        int errorStatus = this.getHttpStatus(error);
        Throwable throwable = this.getError(request);
        if (throwable instanceof TokenException) {
            errorStatus = HttpStatus.UNAUTHORIZED.value();
        }
        return ServerResponse.status((int)errorStatus).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)this.exceptionHandlerAdvice.handle(throwable)));
    }
}

