/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.auth.aspect;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.StpUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import me.youm.frame.auth.annotation.PreAuth;
import me.youm.frame.common.entity.TokenInfo;
import me.youm.frame.common.exception.AuthorityException;
import me.youm.frame.common.exception.TokenException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class PreAuthAspect {
    private static final String ALL_PERMISSION = "*:*:*";

    @Around(value="@annotation(me.youm.frame.auth.annotation.PreAuth)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        PreAuth preAuth = method.getAnnotation(PreAuth.class);
        if (ObjectUtils.isEmpty((Object)preAuth)) {
            return point.proceed();
        }
        if (this.hasPerm(preAuth.hasPerm())) {
            return point.proceed();
        }
        throw new AuthorityException("\u65e0\u6743\u8bbf\u95ee");
    }

    public boolean hasPerm(String permission) {
        SaSession tokenSession;
        try {
            tokenSession = StpUtil.getTokenSession();
        }
        catch (NotLoginException ex) {
            throw new TokenException(ex.getMessage());
        }
        TokenInfo currentUser = (TokenInfo)tokenSession.getModel("user", TokenInfo.class);
        if (StringUtils.isEmpty((Object)currentUser)) {
            return false;
        }
        if (!StringUtils.isEmpty((Object)currentUser) && StringUtils.isEmpty((Object)permission)) {
            return true;
        }
        if (currentUser.getUserName().equalsIgnoreCase("admin") || currentUser.getUserName().equalsIgnoreCase("10000000000")) {
            return true;
        }
        return this.hasPermissions(Arrays.stream(String.valueOf(currentUser.getAuthorities()).split(",")).collect(Collectors.toList()), permission);
    }

    private boolean hasPermissions(Collection<String> authorities, String permission) {
        return authorities.stream().filter(StringUtils::hasText).anyMatch(x -> ALL_PERMISSION.contains((CharSequence)x) || PatternMatchUtils.simpleMatch((String)permission, (String)x));
    }
}

