/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.cache.aspect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import me.youm.frame.cache.annotations.ReactiveCacheEvict;
import me.youm.frame.cache.annotations.ReactiveCachePut;
import me.youm.frame.cache.annotations.ReactiveCacheable;
import me.youm.frame.cache.annotations.ReactiveCaching;
import me.youm.frame.cache.expression.AspectSupportUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
@Aspect
public class ReactiveCacheAspect {
    private static final Logger log = LoggerFactory.getLogger(ReactiveCacheAspect.class);
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    @Pointcut(value="@annotation(me.youm.frame.cache.annotations.ReactiveCacheable)")
    public void cacheablePointCut() {
    }

    @Pointcut(value="@annotation(me.youm.frame.cache.annotations.ReactiveCacheEvict)")
    public void cacheEvictPointCut() {
    }

    @Pointcut(value="@annotation(me.youm.frame.cache.annotations.ReactiveCachePut)")
    public void cachePutPointCut() {
    }

    @Pointcut(value="@annotation(me.youm.frame.cache.annotations.ReactiveCaching)")
    public void cachingPointCut() {
    }

    @Around(value="cacheablePointCut()")
    public Object cacheableAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        log.debug("ReactiveRedisCacheAspect cacheableAround....");
        MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = methodSignature.getMethod();
        String returnTypeName = method.getReturnType().getSimpleName();
        ReactiveCacheable annotation = method.getAnnotation(ReactiveCacheable.class);
        String cacheName = annotation.cacheName();
        String key = annotation.key();
        long timeout = annotation.timeout();
        cacheName = (String)AspectSupportUtils.getKeyValue((JoinPoint)proceedingJoinPoint, cacheName);
        key = (String)AspectSupportUtils.getKeyValue((JoinPoint)proceedingJoinPoint, key);
        String redis_key = cacheName + "_" + key;
        Boolean hasKey = this.redisTemplate.hasKey((Object)redis_key);
        if (hasKey != null && hasKey.booleanValue()) {
            Object o = this.redisTemplate.opsForValue().get((Object)redis_key);
            if (returnTypeName.equals("Flux")) {
                if (o instanceof List) {
                    List list2 = (List)o;
                    return Flux.fromIterable((Iterable)list2);
                }
                return o;
            }
            if (returnTypeName.equals("Mono")) {
                return Mono.just((Object)o);
            }
            return o;
        }
        Object proceed = proceedingJoinPoint.proceed();
        if (returnTypeName.equals("Flux")) {
            return ((Flux)proceed).collectList().doOnNext(list -> this.redisTemplate.opsForValue().set((Object)redis_key, list, timeout, TimeUnit.SECONDS)).flatMapMany(list -> Flux.fromIterable((Iterable)((List)list)));
        }
        if (returnTypeName.equals("Mono")) {
            return ((Mono)proceed).doOnNext(obj -> this.redisTemplate.opsForValue().set((Object)redis_key, obj, timeout, TimeUnit.SECONDS));
        }
        return proceed;
    }

    @Around(value="cacheEvictPointCut()")
    public Object cacheEvictAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        log.debug("ReactiveRedisCacheAspect cacheEvictAround....");
        MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = methodSignature.getMethod();
        String returnTypeName = method.getReturnType().getSimpleName();
        ReactiveCacheEvict annotation = method.getAnnotation(ReactiveCacheEvict.class);
        String cacheName = annotation.cacheName();
        String key = annotation.key();
        boolean allEntries = annotation.allEntries();
        boolean beforeInvocation = annotation.beforeInvocation();
        cacheName = (String)AspectSupportUtils.getKeyValue((JoinPoint)proceedingJoinPoint, cacheName);
        key = (String)AspectSupportUtils.getKeyValue((JoinPoint)proceedingJoinPoint, key);
        if (beforeInvocation) {
            this.deleteRedisCache(cacheName, key, allEntries);
            Object proceed = proceedingJoinPoint.proceed();
            return proceed;
        }
        Object proceed = proceedingJoinPoint.proceed();
        String cacheNameTemp = cacheName;
        String keyTemp = key;
        if (returnTypeName.equals("Flux")) {
            return ((Flux)proceed).collectList().doOnNext(list -> this.deleteRedisCache(cacheNameTemp, keyTemp, allEntries)).flatMapMany(list -> Flux.fromIterable((Iterable)((List)list)));
        }
        if (returnTypeName.equals("Mono")) {
            return ((Mono)proceed).doOnNext(obj -> this.deleteRedisCache(cacheNameTemp, keyTemp, allEntries));
        }
        return proceed;
    }

    @Around(value="cachePutPointCut()")
    public Object cachePutAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        log.debug("ReactiveRedisCacheAspect cachePutAround....");
        MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = methodSignature.getMethod();
        String returnTypeName = method.getReturnType().getSimpleName();
        ReactiveCachePut annotation = method.getAnnotation(ReactiveCachePut.class);
        String cacheName = annotation.cacheName();
        String key = annotation.key();
        long timeout = annotation.timeout();
        cacheName = (String)AspectSupportUtils.getKeyValue((JoinPoint)proceedingJoinPoint, cacheName);
        key = (String)AspectSupportUtils.getKeyValue((JoinPoint)proceedingJoinPoint, key);
        String redis_key = cacheName + "_" + key;
        Boolean hasKey = this.redisTemplate.hasKey((Object)redis_key);
        if (hasKey != null && hasKey.booleanValue()) {
            this.redisTemplate.delete((Object)redis_key);
        }
        Object proceed = proceedingJoinPoint.proceed();
        if (returnTypeName.equals("Flux")) {
            return ((Flux)proceed).collectList().doOnNext(list -> this.redisTemplate.opsForValue().set((Object)redis_key, list, timeout, TimeUnit.SECONDS)).flatMapMany(list -> Flux.fromIterable((Iterable)((List)list)));
        }
        if (returnTypeName.equals("Mono")) {
            return ((Mono)proceed).doOnNext(obj -> this.redisTemplate.opsForValue().set((Object)redis_key, obj, timeout, TimeUnit.SECONDS));
        }
        return proceed;
    }

    @Around(value="cachingPointCut()")
    public Object cachingAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        log.debug("ReactiveRedisCacheAspect cachingAround....");
        MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = methodSignature.getMethod();
        String returnTypeName = method.getReturnType().getSimpleName();
        ReactiveCaching annotation = method.getAnnotation(ReactiveCaching.class);
        ReactiveCacheEvict[] cacheEvicts = annotation.evict();
        ReactiveCachePut[] cachePuts = annotation.put();
        ReactiveCacheable[] cacheables = annotation.cacheable();
        if (cacheables.length > 0) {
            HashMap key_map = new HashMap();
            ArrayList key_list = new ArrayList();
            Arrays.stream(cacheables).forEach(cacheable -> {
                String cacheName = cacheable.cacheName();
                String key = cacheable.key();
                long timeout = cacheable.timeout();
                cacheName = (String)AspectSupportUtils.getKeyValue((JoinPoint)proceedingJoinPoint, cacheName);
                key = (String)AspectSupportUtils.getKeyValue((JoinPoint)proceedingJoinPoint, key);
                String redis_key = cacheName + "_" + key;
                key_map.put(redis_key, timeout);
                key_list.add(redis_key);
            });
            AtomicBoolean isAllKeyHas = new AtomicBoolean(true);
            key_list.forEach(key -> {
                if (!this.redisTemplate.hasKey(key).booleanValue()) {
                    isAllKeyHas.set(false);
                }
            });
            if (isAllKeyHas.get()) {
                Object o = this.redisTemplate.opsForValue().get(key_list.get(0));
                if (returnTypeName.equals("Flux")) {
                    return Flux.fromIterable((Iterable)((List)o));
                }
                if (returnTypeName.equals("Mono")) {
                    return Mono.just((Object)o);
                }
                return o;
            }
            Object proceed = proceedingJoinPoint.proceed();
            if (returnTypeName.equals("Flux")) {
                return ((Flux)proceed).collectList().doOnNext(list -> key_map.forEach((key, val) -> this.redisTemplate.opsForValue().set(key, list, val.longValue(), TimeUnit.SECONDS))).flatMapMany(list -> Flux.fromIterable((Iterable)((List)list)));
            }
            if (returnTypeName.equals("Mono")) {
                return ((Mono)proceed).doOnNext(obj -> key_map.forEach((key, val) -> this.redisTemplate.opsForValue().set(key, obj, val.longValue(), TimeUnit.SECONDS)));
            }
            return proceed;
        }
        HashMap map = new HashMap();
        if (cacheEvicts.length > 0) {
            Arrays.stream(cacheEvicts).forEach(cacheEvict -> {
                String cacheName = cacheEvict.cacheName();
                String key = cacheEvict.key();
                boolean allEntries = cacheEvict.allEntries();
                boolean beforeInvocation = cacheEvict.beforeInvocation();
                cacheName = (String)AspectSupportUtils.getKeyValue((JoinPoint)proceedingJoinPoint, cacheName);
                key = (String)AspectSupportUtils.getKeyValue((JoinPoint)proceedingJoinPoint, key);
                if (beforeInvocation) {
                    this.deleteRedisCache(cacheName, key, allEntries);
                } else if (allEntries) {
                    map.put(cacheName, true);
                } else {
                    map.put(cacheName + "_" + key, false);
                }
            });
        }
        Object proceed = proceedingJoinPoint.proceed();
        if (cachePuts.length > 0) {
            HashMap key_map = new HashMap();
            Arrays.stream(cachePuts).forEach(cachePut -> {
                String cacheName = cachePut.cacheName();
                String key = cachePut.key();
                long timeout = cachePut.timeout();
                cacheName = (String)AspectSupportUtils.getKeyValue((JoinPoint)proceedingJoinPoint, cacheName);
                key = (String)AspectSupportUtils.getKeyValue((JoinPoint)proceedingJoinPoint, key);
                String redis_key = cacheName + "_" + key;
                key_map.put(redis_key, timeout);
                boolean hasKey = this.redisTemplate.hasKey((Object)redis_key);
                if (hasKey) {
                    this.redisTemplate.delete((Object)redis_key);
                }
            });
            if (returnTypeName.equals("Flux")) {
                return ((Flux)proceed).collectList().doOnNext(list -> {
                    if (map.size() > 0) {
                        map.forEach((key, val) -> this.deleteRedisCache((String)key, (boolean)val));
                    }
                    key_map.forEach((key, val) -> this.redisTemplate.opsForValue().set(key, list, val.longValue(), TimeUnit.SECONDS));
                }).flatMapMany(list -> Flux.fromIterable((Iterable)((List)list)));
            }
            if (returnTypeName.equals("Mono")) {
                return ((Mono)proceed).doOnNext(obj -> {
                    if (map.size() > 0) {
                        map.forEach((key, val) -> this.deleteRedisCache((String)key, (boolean)val));
                    }
                    key_map.forEach((key, val) -> this.redisTemplate.opsForValue().set(key, obj, val.longValue(), TimeUnit.SECONDS));
                });
            }
            return proceed;
        }
        if (returnTypeName.equals("Flux")) {
            return ((Flux)proceed).collectList().doOnNext(list -> {
                if (map.size() > 0) {
                    map.forEach((key, val) -> this.deleteRedisCache((String)key, (boolean)val));
                }
            }).flatMapMany(list -> Flux.fromIterable((Iterable)((List)list)));
        }
        if (returnTypeName.equals("Mono")) {
            return ((Mono)proceed).doOnNext(obj -> {
                if (map.size() > 0) {
                    map.forEach((key, val) -> this.deleteRedisCache((String)key, (boolean)val));
                }
            });
        }
        return proceed;
    }

    private void deleteRedisCache(String key, boolean clearAll) {
        if (clearAll) {
            Set keys = this.redisTemplate.keys((Object)(key + "_*"));
            if (keys != null && !keys.isEmpty()) {
                this.redisTemplate.delete((Collection)keys);
            }
        } else {
            Boolean hasKey = this.redisTemplate.hasKey((Object)key);
            if (hasKey != null && hasKey.booleanValue()) {
                this.redisTemplate.delete((Object)key);
            }
        }
    }

    private void deleteRedisCache(String cacheName, String key, boolean clearAll) {
        Object redis_key = clearAll ? cacheName : cacheName + "_" + key;
        this.deleteRedisCache((String)redis_key, clearAll);
    }
}

