package me.youm.frame.cloud.bootstrap;

import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;


/**
 * @author youta
 */
@Order(value = Ordered.HIGHEST_PRECEDENCE + 1)
public class CustomPropertySourceLocator implements PropertySourceLocator {

    @Override
    public PropertySource<?> locate(Environment environment) {
        Map<String, Object> map = new HashMap<>();
        MapPropertySource source = new MapPropertySource("youm", map);
        map.put("spring.cloud.consul.config.watch.enabled", false);
        map.put("spring.cloud.consul.config.fail-fast", false);
        map.put("spring.data.redis.repositories.enabled", false);
        map.put("sentry.traces-sample-rate", 0.5);
        String envName = environment.getProperty("spring.profiles.active");
        if (Objects.equals(envName, "prod")) {
            map.put("opentracing.jaeger.udp-sender.host", "jaeger");
        }
        return source;
    }
}
