/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.common.utils;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class OptionalBean<T>
implements Serializable {
    private static final OptionalBean<?> EMPTY = new OptionalBean();
    private final T value;

    private OptionalBean() {
        this.value = null;
    }

    private OptionalBean(T value) {
        this.value = Objects.requireNonNull(value);
    }

    public static <T> OptionalBean<T> of(T value) {
        return new OptionalBean<T>(value);
    }

    public static <T> OptionalBean<T> ofNullable(T value) {
        return value == null ? OptionalBean.empty() : OptionalBean.of(value);
    }

    public T get() {
        return Objects.isNull(this.value) ? null : (T)this.value;
    }

    public <R> OptionalBean<R> getBean(Function<? super T, ? extends R> fn) {
        return Objects.isNull(this.value) ? OptionalBean.empty() : OptionalBean.ofNullable(fn.apply(this.value));
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.value != null ? this.value : other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public static <T> OptionalBean<T> empty() {
        OptionalBean<?> none = EMPTY;
        return none;
    }
}

