package me.youm.frame.common.exception;

import io.rsocket.exceptions.CustomRSocketException;
import lombok.Getter;
import me.youm.frame.common.constants.ResultConstant;
import me.youm.frame.common.enums.EnumInterface;

/**
 * rsocket跨服务异常
 *
 * @author youta
 */
@Getter
public class ServerException extends CustomRSocketException implements EnumInterface {

    private static final long serialVersionUID = -109638013567529873L;

    protected String msg = ResultConstant.ERROR_MSG;

    protected int code = ResultConstant.ERROR_CODE;

    public ServerException(int code, String message) {
        super(code, message);
    }

    public ServerException(EnumInterface enums) {
        super(enums.getCode(), enums.getMsg());
    }

}
