/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.common.utils;

import java.util.Random;

public class NumberUtil {
    private static String[] hanArr = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static String[] unitArr = new String[]{"\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767d", "\u5343", "\u4ebf", "\u5341", "\u767e", "\u5343"};

    public static int stoi(String string) {
        return NumberUtil.stoi(string, 0);
    }

    public static int stoi(String string, int defaultValue) {
        int id;
        if (string == null || string.equalsIgnoreCase("") || string.equals("null")) {
            return defaultValue;
        }
        try {
            id = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defaultValue;
        }
        return id;
    }

    public static long stol(String string) {
        return NumberUtil.stol(string, 0L);
    }

    public static long stol(String string, long defaultValue) {
        long ret;
        if (string == null || string.equalsIgnoreCase("")) {
            return defaultValue;
        }
        try {
            ret = Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defaultValue;
        }
        return ret;
    }

    public static double stod(String string) {
        return NumberUtil.stod(string, 0.0);
    }

    public static double stod(String string, double defaultValue) {
        double ret;
        if (string == null || string.equalsIgnoreCase("")) {
            return defaultValue;
        }
        try {
            ret = Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defaultValue;
        }
        return ret;
    }

    public static String toChineseNum(int number) {
        String numStr = String.valueOf(number);
        Object result = "";
        int numLen = numStr.length();
        for (int i = 0; i < numLen; ++i) {
            int num = numStr.charAt(i) - 48;
            if (i != numLen - 1 && num != 0) {
                result = (String)result + hanArr[num] + unitArr[numLen - 2 - i];
                if (number < 10 || number >= 20) continue;
                result = ((String)result).substring(1);
                continue;
            }
            if (number >= 10 && number % 10 == 0) continue;
            result = (String)result + hanArr[num];
        }
        return result;
    }

    public static int random(int min, int max) {
        return new Random().nextInt(max - min) + min;
    }
}

