package me.youm.frame.common.constants;

/**
 * @author youta
 */
public class Oauth2Constant {

    public static final String ALL = "/**";

    private static final String OAUTH_ALL = "/oauth/**";

    public static final String OAUTH_TOKEN = "/oauth/token";

    /**
     * 发送短信验证码 或 验证短信验证码时，传递手机号的参数的名称
     */
    public static final String DEFAULT_PARAMETER_NAME_MOBILE = "mobile";

    /**
     * 社交登录，传递的参数名称
     */
    public static final String DEFAULT_PARAMETER_NAME_SOCIAL = "social";

    /**
     * 验证码 key
     */
    public static final String VALIDATE_CODE_KEY = "key";
    /**
     * 验证码 code
     */
    public static final String VALIDATE_CODE_CODE = "code";
    /**
     * 认证类型参数 key
     */
    public static final String GRANT_TYPE = "grant_type";
    /**
     * 登录类型
     */
    public static final String LOGIN_TYPE = "login_type";

    /**
     * 刷新模式
     */
    public static final String REFRESH_TOKEN = "refresh_token";
    /**
     * 授权码模式
     */
    public static final String AUTHORIZATION_CODE = "authorization_code";
    /**
     * 客户端模式
     */
    public static final String CLIENT_CREDENTIALS = "client_credentials";
    /**
     * 密码模式
     */
    public static final String PASSWORD = "password";
    /**
     * 简化模式
     */
    public static final String IMPLICIT = "implicit";

    public static final String CAPTCHA_HEADER_KEY = "key";

    public static final String CAPTCHA_HEADER_CODE = "code";

    public static final int LOGIN_USERNAME_TYPE = 1;

    public static final int LOGIN_MOBILE_TYPE = 2;

    public static final String HEADER_TOKEN = "Mine-Auth";
    public final static String OAUTH2_TOKEN_TYPE = "bearer";

    public static final String SUPER_ADMIN = "admin";

    /**
     * 字段描述开始：用户ID
     */
    public static final String USER_ID = "userId";

    /**
     * 用户名
     */
    public static final String USER_NAME = "userName";

    /**
     * 用户头像
     */
    public static final String AVATAR = "avatar";

    /**
     * 用户权限ID
     */
    public static final String ROLE_ID = "roleId";

    /**
     * 用户类型
     */
    public static final String TYPE = "type";

    /**
     * 权限
     */
    public static final String AUTHORITIES = "authorities";

    public static final String YOUM_USER_TOKEN_KEY = "youm:login:token:";
}
