package me.youm.frame.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author youta
 */
@Getter
@AllArgsConstructor
public enum CodeEnum {

    /**
     * 操作成功
     */
    SUCCESS(200, "操作成功"),
    /**
     * 业务异常
     */
    BAD_REQUEST(400, "业务异常"),
    /**
     * 服务未找到
     */
    NOT_FOUND(404, "资源不存在"),
    METHOD_NOT_ALLOWED(405, "请求方式不正确"),
    /**
     * 服务异常
     */
    ERROR(500, "服务异常"),
    /**
     * Too Many Requests
     */
    TOO_MANY_REQUESTS(429, "Too Many Requests"),
    /**
     * 参数错误
     */
    GLOBAL_PARAM_ERROR(4000, "参数错误"),
    FILE_SIZE_TOO_LONG_ERROR(7001, "文件大小超限"),
    BUCKET_NOT_EXIST(7002, "存储空间不存在"),
    FILE_UPLOAD_ERROR(7003, "文件上传失败"),
    ALI_YUN_OSS_ERROR(7004, "阿里云oss错误"),

    ;
    /**
     * 状态码
     */
    final int code;
    /**
     * 消息内容
     */
    final String msg;

}
