package me.youm.frame.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author youta
 */
@Getter
@AllArgsConstructor
public enum CodeEnum {

    /**
     * 操作成功
     */
    SUCCESS(200, "操作成功"),
    /**
     * 业务异常
     */
    BAD_REQUEST(400, "业务异常"),
    UNAUTHORIZED(401, "请求未授权"),
    FORBIDDEN(403, "无权访问"),
    NOT_FOUND(404, "资源不存在"),
    METHOD_NOT_ALLOWED(405, "请求方式不正确"),
    /**
     * 服务异常
     */
    ERROR(500, "服务异常"),
    /**
     * Too Many Requests
     */
    TOO_MANY_REQUESTS(429, "Too Many Requests"),
    /**
     * 参数错误
     */
    GLOBAL_PARAM_ERROR(4000, "参数错误"),


    SELECT_NON_EXISTENT(6001, "查找数据失败,查找对象不存在"),
    SELECT_PROPERTY_NOT_EMPTY(6002, "查询属性条件不允许为空"),
    SELECT_PROPERTY_NAME_NOT_EMPTY(6003, "查询属性条件名不允许为空"),
    KEY_NOT_NULL(6004, "主键不允许为空"),

    UPDATE_ERROR(6005, "更新数据失败"),
    UPDATE_NON_EXISTENT(6006, "更新数据失败, 更新对象不存在"),
    UPDATE_EXISTENT(6007, "更新数据失败, 更新对象已存在"),
    UPDATE_ITEM_REPEAT(6008, "更新数据失败,更新列表中存在重复的项目"),
    UPDATE_NEW_BY_OLD_NOT_ALLOWED(6009, "更新失败，不允许旧数据覆盖数据库中新的数据"),
    DELETE_NON_EXISTENT(6010, "删除数据失败, 删除对象不存在."),

    FILE_SIZE_TOO_LONG_ERROR(7001, "文件大小超限"),
    BUCKET_NOT_EXIST(7002, "存储空间不存在"),
    FILE_UPLOAD_ERROR(7003, "文件上传失败"),
    ALI_YUN_OSS_ERROR(7004, "阿里云oss错误"),
    ;
    /**
     * 状态码
     */
    final int code;
    /**
     * 消息内容
     */
    final String msg;

}
