package me.youm.frame.common.enums;

import lombok.Getter;

/**
 *@author youta
 */
@Getter
public enum ConditionRelationEnum {

    NOT(-1, "非关系--条件取反"),
    OR(0, "或关系--满足任一条件"),
    AND(1, "与关系--所有条件满足");

    /**
     * 枚举值
     */
    private int value;

    /**
     * 枚举说明
     */
    private String desc;

    ConditionRelationEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static ConditionRelationEnum getByValue(int value) {
        switch (value) {
            case -1:
                return NOT;
            case 1:
                return AND;
            default:
                return OR;
        }

    }
}
