package me.youm.frame.common.utils;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import lombok.extern.slf4j.Slf4j;


/**
 * IP工具类
 *
 * @author youta
 */
@Slf4j
public class IPUtil {

	private final static boolean ipLocal = false;
	private final static String URI = "http://whois.pconline.com.cn/ipJson.jsp?ip=%s&json=true";
	/**
	 * 根据ip获取详细地址
	 */
	public static String getCityInfo(String ip) {
		if (ipLocal) {
			return null;
		} else {
			return getHttpCityInfo(ip);
		}
	}

	/**
	 * 根据ip获取详细地址
	 */
	public static String getHttpCityInfo(String ip) {
		String api = String.format(URI, ip);
		JSONObject object = JSONUtil.parseObj(HttpUtil.get(api));
		return object.getStr("addr");
	}

}
