package me.youm.frame.common.utils;

import me.youm.frame.common.constants.ShoreConstant;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * @author youta
 */
public class TraceUtil {


    /**
     * 从header和参数中获取traceId
     * 从前端传入数据
     *
     * @param request　HttpServletRequest
     * @return traceId
     */
    public static String getTraceId(HttpServletRequest request) {
        String traceId = request.getParameter(ShoreConstant.LOG_TRACE_ID);
        if (!StringUtils.hasText(traceId)) {
            traceId = request.getHeader(ShoreConstant.LOG_TRACE_ID);
        }
        return traceId;
    }

    /**
     * 传递traceId至MDC
     * @param traceId　跟踪ID
     */
    public static void mdcTraceId (String traceId) {
        if (StringUtils.hasText(traceId)) {
            MDC.put(ShoreConstant.LOG_TRACE_ID, traceId);
        }
    }
}
