/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.common.function;

import java.util.Optional;
import java.util.function.Function;
import me.youm.frame.common.function.CheckedFunction;
import org.springframework.data.util.Pair;

public class Either<L, R> {
    private final L left;
    private final R right;

    private Either(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public static <L, R> Either<L, R> Left(L value) {
        return new Either<L, Object>(value, null);
    }

    public static <L, R> Either<L, R> Right(R value) {
        return new Either<Object, R>(null, value);
    }

    public Optional<L> getLeft() {
        return Optional.ofNullable(this.left);
    }

    public Optional<R> getRight() {
        return Optional.ofNullable(this.right);
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public <T> Optional<T> mapLeft(Function<? super L, T> mapper) {
        if (this.isLeft()) {
            return Optional.of(mapper.apply(this.left));
        }
        return Optional.empty();
    }

    public <T> Optional<T> mapRight(Function<? super R, T> mapper) {
        if (this.isRight()) {
            return Optional.of(mapper.apply(this.right));
        }
        return Optional.empty();
    }

    public static <T, R> Function<T, Either> lift(CheckedFunction<T, R> function) {
        return t -> {
            try {
                return Either.Right(function.apply(t));
            }
            catch (Exception ex) {
                return Either.Left(ex);
            }
        };
    }

    public static <T, R> Function<T, Either> liftWithValue(CheckedFunction<T, R> function) {
        return t -> {
            try {
                return Either.Right(function.apply(t));
            }
            catch (Exception ex) {
                return Either.Left(Pair.of((Object)ex, (Object)t));
            }
        };
    }

    public String toString() {
        if (this.isLeft()) {
            return "Left(" + this.left + ")";
        }
        return "Right(" + this.right + ")";
    }
}

