/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.common.model;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import me.youm.frame.common.utils.MapUtils;

public class IPage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String JPA_PAGE_PACKAGE = "org.springframework.data.domain";
    private static final String MBP_PAGE_PACKAGE = "com.baomidou.mybatisplus.extension.plugins.pagination";
    private long pageIndex;
    private long totalCount;
    private long pageSize;
    private long totalPage;
    private List<?> content;

    public IPage() {
    }

    public IPage(Object page) {
        Map<String, Object> paramMap = MapUtils.objectToMap2(page);
        String packageName = page.getClass().getPackage().getName();
        if (packageName.equalsIgnoreCase(JPA_PAGE_PACKAGE)) {
            this.pageIndex = ((Integer)paramMap.get("number")).intValue();
            this.pageSize = ((Integer)paramMap.get("size")).intValue();
            this.totalPage = ((Integer)paramMap.get("totalPages")).intValue();
            this.totalCount = (Long)paramMap.get("totalElements");
            this.content = (List)paramMap.get("content");
        } else if (packageName.equalsIgnoreCase(MBP_PAGE_PACKAGE)) {
            this.pageIndex = (Long)paramMap.get("current");
            this.totalCount = (Long)paramMap.get("total");
            this.pageSize = (Long)paramMap.get("size");
            if (this.pageSize > 0L) {
                long pages = this.totalCount / this.pageSize;
                if (this.totalCount % this.pageSize != 0L) {
                    ++pages;
                }
                this.totalPage = pages;
            }
            this.content = (List)paramMap.get("records");
        } else {
            this.pageIndex = (Long)paramMap.get("pageIndex");
            this.totalCount = (Long)paramMap.get("totalCount");
            this.totalPage = (Long)paramMap.get("totalPage");
            this.pageSize = (Long)paramMap.get("pageSize");
            this.content = (List)paramMap.get("content");
        }
    }

    public IPage(long pageIndex, long totalCount, long pageSize, long totalPage, List<?> content) {
        this.pageIndex = pageIndex;
        this.totalCount = totalCount;
        this.pageSize = pageSize;
        this.totalPage = totalPage;
        this.content = content;
    }

    public static IPage page() {
        return new IPage();
    }

    public static IPage page(Object page) {
        return new IPage(page);
    }

    public static IPage page(long pageIndex, long totalCount, long pageSize, long totalPage, List<?> content) {
        return new IPage(pageIndex, totalCount, pageSize, totalPage, content);
    }

    public long getPageIndex() {
        return this.pageIndex;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public List<?> getContent() {
        return this.content;
    }

    public void setPageIndex(long pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    public void setContent(List<?> content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IPage)) {
            return false;
        }
        IPage other = (IPage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageIndex() != other.getPageIndex()) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotalPage() != other.getTotalPage()) {
            return false;
        }
        List<?> this$content = this.getContent();
        List<?> other$content = other.getContent();
        return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IPage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pageIndex = this.getPageIndex();
        result = result * 59 + (int)($pageIndex >>> 32 ^ $pageIndex);
        long $totalCount = this.getTotalCount();
        result = result * 59 + (int)($totalCount >>> 32 ^ $totalCount);
        long $pageSize = this.getPageSize();
        result = result * 59 + (int)($pageSize >>> 32 ^ $pageSize);
        long $totalPage = this.getTotalPage();
        result = result * 59 + (int)($totalPage >>> 32 ^ $totalPage);
        List<?> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        return result;
    }

    public String toString() {
        return "IPage(pageIndex=" + this.getPageIndex() + ", totalCount=" + this.getTotalCount() + ", pageSize=" + this.getPageSize() + ", totalPage=" + this.getTotalPage() + ", content=" + this.getContent() + ")";
    }
}

