/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.common.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import me.youm.frame.common.constants.ResultConstant;
import me.youm.frame.common.enums.EnumInterface;
import me.youm.frame.common.exception.BusinessException;
import reactor.core.publisher.Mono;

@ApiModel(description="\u54cd\u5e94\u5b9e\u4f53")
public class R<T>
implements Serializable {
    @ApiModelProperty(value="\u662f\u5426\u6210\u529f", required=true)
    private Boolean success;
    @ApiModelProperty(value="\u54cd\u5e94\u7f16\u7801", required=true)
    private Integer code;
    @ApiModelProperty(value="\u54cd\u5e94\u4fe1\u606f", required=true)
    private String message;
    @ApiModelProperty(value="\u627f\u8f7d\u6570\u636e")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private T data;

    public static <T> Mono<T> error(EnumInterface exceptionEnum) {
        return Mono.error((Throwable)new BusinessException(exceptionEnum, new Object[0]));
    }

    public static <T> Mono<R<T>> ok(Mono<T> monoBody) {
        return R.monoResponseCreate(monoBody, ResultConstant.SUCCESS_CODE, "success", true);
    }

    public static <T> Mono<R<T>> ok(Mono<T> monoBody, String msg) {
        return R.monoResponseCreate(monoBody, ResultConstant.SUCCESS_CODE, msg, true);
    }

    public static <T> Mono<R<T>> ok(Mono<T> monoBody, int code, String msg) {
        return R.monoResponseCreate(monoBody, code, msg, true);
    }

    public static <T> Mono<R<T>> failed(Mono<T> monoBody) {
        return R.monoResponseCreate(monoBody, ResultConstant.ERROR_CODE, "error", false);
    }

    public static <T> Mono<R<T>> failed(Mono<T> monoBody, String msg) {
        return R.monoResponseCreate(monoBody, ResultConstant.ERROR_CODE, msg, false);
    }

    public static <T> Mono<R<T>> failed(Mono<T> monoBody, int code, String msg) {
        return R.monoResponseCreate(monoBody, code, msg, false);
    }

    public static <T> Mono<R<T>> ok() {
        return R.responseCreate(ResultConstant.SUCCESS_CODE, "success", true);
    }

    public static <T> Mono<R<T>> failed() {
        return R.responseCreate(ResultConstant.ERROR_CODE, "error", false);
    }

    public static <T> Mono<R<T>> ok(T data) {
        return R.responseCreate(data, ResultConstant.SUCCESS_CODE, "success", true);
    }

    public static <T> Mono<R<T>> ok(T data, String msg) {
        return R.responseCreate(data, ResultConstant.SUCCESS_CODE, msg, true);
    }

    public static <T> Mono<R<T>> ok(int code, String msg) {
        return R.responseCreate(code, msg, true);
    }

    public static <T> Mono<R<T>> ok(T data, int code, String msg) {
        return R.responseCreate(data, code, msg, true);
    }

    public static <T> Mono<R<T>> failed(T data) {
        return R.responseCreate(data, ResultConstant.ERROR_CODE, "error", false);
    }

    public static <T> Mono<R<T>> failed(T data, String msg) {
        return R.responseCreate(data, ResultConstant.ERROR_CODE, msg, false);
    }

    public static <T> Mono<R<T>> failed(int code, String msg) {
        return R.responseCreate(code, msg, false);
    }

    public static <T> Mono<R<T>> failed(T data, int code, String msg) {
        return R.responseCreate(data, code, msg, false);
    }

    private static <T> Mono<R<T>> responseCreate(int code, String msg, Boolean success) {
        R<T> r = new R<T>();
        r.setCode(code);
        r.setMessage(msg);
        r.setSuccess(success);
        return Mono.just(r);
    }

    private static <T> Mono<R<T>> responseCreate(T data, int code, String msg, Boolean success) {
        Mono monoData = Mono.just(data);
        return R.getMono(code, msg, success, monoData);
    }

    private static <T> Mono<R<T>> monoResponseCreate(Mono<T> monoData, int code, String msg, Boolean success) {
        return R.getMono(code, msg, success, monoData);
    }

    private static <T> Mono<R<T>> getMono(int code, String msg, Boolean success, Mono<T> monoData) {
        return monoData.map(x -> {
            R<Object> r = new R<Object>();
            r.setCode(code);
            r.setData(x);
            r.setMessage(msg);
            r.setSuccess(success);
            return r;
        }).switchIfEmpty(R.ok(code, msg));
    }

    public Boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public R<T> setSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    public R<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public R<T> setCode(Integer code) {
        this.code = code;
        return this;
    }

    public R<T> setData(T data) {
        this.data = data;
        return this;
    }

    public String toString() {
        return "R(success=" + this.success + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

