/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.common.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import me.youm.frame.common.constants.ResultConstant;
import me.youm.frame.common.enums.CodeEnum;
import me.youm.frame.common.enums.EnumInterface;
import org.springframework.lang.NonNull;

@ApiModel(description="\u54cd\u5e94\u5b9e\u4f53")
public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 129486345465L;
    @ApiModelProperty(value="\u662f\u5426\u6210\u529f", required=true)
    private Boolean success;
    @ApiModelProperty(value="\u54cd\u5e94\u7f16\u7801", required=true)
    private Integer code;
    @ApiModelProperty(value="\u54cd\u5e94\u4fe1\u606f", required=true)
    private String message;
    @ApiModelProperty(value="\u627f\u8f7d\u6570\u636e")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private T data;

    public Result() {
    }

    public static boolean isOk(@NonNull Result<?> result) {
        return Objects.requireNonNull(result).isSuccess();
    }

    public static boolean isNotOk(Result<?> result) {
        return !Result.isOk(result);
    }

    public Result(Boolean success, String message, Integer code, T data) {
        this.success = success;
        this.message = message;
        this.code = code;
        this.data = data;
    }

    public static <T> Result<T> ok() {
        Result<T> responseData = new Result<T>();
        responseData.setSuccess(true);
        responseData.setMessage("success");
        responseData.setCode(ResultConstant.SUCCESS_CODE);
        return responseData;
    }

    public static <T> Result<T> ok(T data) {
        Result<T> responseData = new Result<T>();
        responseData.setSuccess(true);
        responseData.setMessage("success");
        responseData.setCode(ResultConstant.SUCCESS_CODE);
        responseData.setData(data);
        return responseData;
    }

    public static Result<?> error() {
        Result responseData = new Result();
        responseData.setSuccess(false);
        responseData.setMessage("error");
        responseData.setCode(ResultConstant.ERROR_CODE);
        return responseData;
    }

    public static Result<?> error(String msg) {
        Result responseData = new Result();
        responseData.setSuccess(false);
        responseData.setMessage(msg);
        responseData.setCode(ResultConstant.ERROR_CODE);
        return responseData;
    }

    public static Result<?> error(Integer code, String msg) {
        Result responseData = new Result();
        responseData.setSuccess(false);
        responseData.setMessage(msg);
        responseData.setCode(code);
        return responseData;
    }

    public static Result<?> error(EnumInterface failure) {
        Result responseData = new Result();
        responseData.setSuccess(false);
        responseData.setCode(failure.getCode());
        responseData.setMessage(failure.getMsg());
        return responseData;
    }

    public static Result<?> error(CodeEnum codeEnum) {
        Result responseData = new Result();
        responseData.setSuccess(false);
        responseData.setMessage(codeEnum.getMsg());
        responseData.setCode(codeEnum.getCode());
        return responseData;
    }

    public Boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public Result<T> setSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    public Result<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public Result<T> setCode(Integer code) {
        this.code = code;
        return this;
    }

    public Result<T> setData(T data) {
        this.data = data;
        return this;
    }

    public String toString() {
        return "Result(success=" + this.success + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

