/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.common.utils;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import me.youm.frame.common.utils.BeanUtils;
import org.apache.commons.beanutils.BeanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapUtils {
    private static final Logger log = LoggerFactory.getLogger(MapUtils.class);

    public static Map<?, ?> objectToMap1(Object obj) {
        if (obj == null) {
            return null;
        }
        return new BeanMap(obj);
    }

    public static Object mapToObject1(Map<?, ?> map, Class beanClass) throws Exception {
        if (map == null) {
            return null;
        }
        Object obj = beanClass.newInstance();
        BeanUtils.populate(obj, map);
        return obj;
    }

    public static Map<String, Object> objectToMap2(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanInfo beanInfo = null;
        try {
            PropertyDescriptor[] propertyDescriptors;
            beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.compareToIgnoreCase("class") == 0) continue;
                Method getter = property.getReadMethod();
                Object value = getter != null ? getter.invoke(obj, new Object[0]) : null;
                map.put(key, value);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
        return map;
    }

    public static Object mapToObject2(Map<String, Object> map, Class<?> beanClass) {
        if (map == null) {
            return null;
        }
        Object obj = null;
        try {
            PropertyDescriptor[] propertyDescriptors;
            obj = beanClass.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method setter = property.getWriteMethod();
                if (setter == null) continue;
                setter.invoke(obj, map.get(property.getName()));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
        return obj;
    }

    public static Object mapToObject3(Map<String, Object> map, Class<?> beanClass) throws Exception {
        Field[] fields;
        if (map == null) {
            return null;
        }
        Object obj = beanClass.newInstance();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
            field.setAccessible(true);
            field.set(obj, map.get(field.getName()));
        }
        return obj;
    }

    public static Map<String, Object> objectToMap3(Object obj) throws Exception {
        Field[] declaredFields;
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : declaredFields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(obj));
        }
        return map;
    }

    public static String map2Json(Map<String, Object> map) {
        ObjectMapper mapper = new ObjectMapper();
        String result = null;
        try {
            result = mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage());
        }
        return result;
    }

    public static Map json2Map(String json) {
        Map maps = null;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            maps = (Map)objectMapper.readValue(json, Map.class);
            log.debug(maps.toString());
        }
        catch (JsonParseException e) {
            log.error(e.getMessage());
        }
        catch (JsonMappingException e) {
            log.error(e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return maps;
    }
}

