package me.youm.frame.dozer.config;

import com.github.dozermapper.core.Mapper;
import com.github.dozermapper.spring.DozerBeanMapperFactoryBean;
import me.youm.frame.dozer.props.DozerProperties;
import me.youm.frame.dozer.util.DozerUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.io.IOException;

/**
 * Dozer配置
 * @author youta
 */
@Configuration
@ConditionalOnClass({DozerBeanMapperFactoryBean.class, Mapper.class})
@ConditionalOnMissingBean(Mapper.class)
@EnableConfigurationProperties(DozerProperties.class)
public class DozerConfiguration {

    private final DozerProperties properties;


    /**
     * Constructor for creating auto configuration.
     *
     * @param properties properties
     */
    public DozerConfiguration(DozerProperties properties) {
        this.properties = properties;
    }

    @Bean
    public DozerUtil getDozerUtil(Mapper mapper) {
        return new DozerUtil(mapper);
    }

    /**
     * Creates default Dozer mapper
     *
     * @return Dozer mapper
     * @throws IOException if there is an exception during initialization.
     */
    @Bean
    public DozerBeanMapperFactoryBean dozerMapper() throws IOException {
        DozerBeanMapperFactoryBean factoryBean = new DozerBeanMapperFactoryBean();
        factoryBean.setMappingFiles(properties.resolveMapperLocations());
        return factoryBean;
    }

}
