/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.dozer.config;

import com.github.dozermapper.core.Mapper;
import com.github.dozermapper.spring.DozerBeanMapperFactoryBean;
import java.io.IOException;
import me.youm.frame.dozer.props.DozerProperties;
import me.youm.frame.dozer.util.DozerUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DozerBeanMapperFactoryBean.class, Mapper.class})
@ConditionalOnMissingBean(value={Mapper.class})
@EnableConfigurationProperties(value={DozerProperties.class})
public class DozerConfiguration {
    private final DozerProperties properties;

    public DozerConfiguration(DozerProperties properties) {
        this.properties = properties;
    }

    @Bean
    public DozerUtil getDozerUtil(Mapper mapper) {
        return new DozerUtil(mapper);
    }

    @Bean
    public DozerBeanMapperFactoryBean dozerMapper() throws IOException {
        DozerBeanMapperFactoryBean factoryBean = new DozerBeanMapperFactoryBean();
        factoryBean.setMappingFiles(this.properties.resolveMapperLocations());
        return factoryBean;
    }
}

