package me.youm.frame.feign.config;

import feign.RequestInterceptor;
import lombok.extern.slf4j.Slf4j;
import me.youm.frame.common.constants.ShoreConstant;
import me.youm.frame.common.utils.TraceUtil;
import org.slf4j.MDC;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;

/**
 * feign拦截器
 * @author youta
 */
@Slf4j
public class FeignInterceptorConfiguration {

    /**
     * 使用feign client发送请求时，传递traceId
     * @return RequestInterceptor
     */
    @Bean
    public RequestInterceptor requestInterceptor() {
        return requestTemplate -> {
            //传递日志traceId
            String traceId = MDC.get(ShoreConstant.LOG_TRACE_ID);
            if (!StringUtils.hasText(traceId)) {
                ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
                if (attributes != null) {
                    HttpServletRequest request = attributes.getRequest();
                    Enumeration<String> headerNames = request.getHeaderNames();
                    if (headerNames != null) {
                        String headerName;
                        while (headerNames.hasMoreElements()) {
                            headerName = headerNames.nextElement();
                            if (headerName.equalsIgnoreCase(ShoreConstant.LOG_TRACE_ID)) {
                                traceId = request.getHeader(headerName);
                                requestTemplate.header(ShoreConstant.LOG_TRACE_ID, traceId);
                                TraceUtil.mdcTraceId(traceId);
                            }
                            String values = request.getHeader(headerName);
                            requestTemplate.header(headerName, values);
                        }
                    }
                }
            } else {
                if (StringUtils.hasText(traceId)) {
                    requestTemplate.header(ShoreConstant.LOG_TRACE_ID, traceId);
                }
            }
        };
    }
}
