package me.youm.frame.feign.fallback;

import feign.FeignException;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import me.youm.frame.common.model.Result;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.lang.Nullable;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;

/**
 * fallback 代理处理
 * @author youta
 * @param <T>
 */
@Slf4j
@AllArgsConstructor
public class ShoreFeignFallback<T> implements MethodInterceptor {

    private final Class<T> targetType;
    private final String targetName;
    private final Throwable cause;

    @Nullable
    @Override
    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        String errorMessage = cause.getMessage();
        log.error("FeignFallback:[{}.{}] serviceId:[{}] message:[{}]", targetType.getName(), method.getName(), targetName, errorMessage);
        Class<?> returnType = method.getReturnType();
        if (Result.class != returnType) {
            return null;
        }
        // 非 FeignException
        if (!(cause instanceof FeignException)) {
            return Result.error(errorMessage);
        }
        FeignException exception = (FeignException) cause;
        Optional<ByteBuffer> byteBuffer = exception.responseBody();
        // 如果返回的数据为空
        if (byteBuffer.isEmpty()) {
            return Result.error(errorMessage);
        }
        return Result.error(byteBuffer.toString());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ShoreFeignFallback<?> that = (ShoreFeignFallback<?>) o;
        return targetType.equals(that.targetType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(targetType);
    }
}
