/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.feign.config;

import feign.RequestInterceptor;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import me.youm.frame.common.utils.TraceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class FeignInterceptorConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FeignInterceptorConfiguration.class);

    @Bean
    public RequestInterceptor requestInterceptor() {
        return requestTemplate -> {
            String traceId = MDC.get((String)"traceId");
            if (!StringUtils.hasText((String)traceId)) {
                HttpServletRequest request;
                Enumeration headerNames;
                ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                if (attributes != null && (headerNames = (request = attributes.getRequest()).getHeaderNames()) != null) {
                    while (headerNames.hasMoreElements()) {
                        String headerName = (String)headerNames.nextElement();
                        if (headerName.equalsIgnoreCase("traceId")) {
                            traceId = request.getHeader(headerName);
                            requestTemplate.header("traceId", new String[]{traceId});
                            TraceUtil.mdcTraceId((String)traceId);
                        }
                        String values = request.getHeader(headerName);
                        requestTemplate.header(headerName, new String[]{values});
                    }
                }
            } else if (StringUtils.hasText((String)traceId)) {
                requestTemplate.header("traceId", new String[]{traceId});
            }
        };
    }
}

