/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.feign.fallback;

import feign.FeignException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import me.youm.frame.common.model.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.lang.Nullable;

public class ShoreFeignFallback<T>
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ShoreFeignFallback.class);
    private final Class<T> targetType;
    private final String targetName;
    private final Throwable cause;

    @Nullable
    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        String errorMessage = this.cause.getMessage();
        log.error("FeignFallback:[{}.{}] serviceId:[{}] message:[{}]", new Object[]{this.targetType.getName(), method.getName(), this.targetName, errorMessage});
        Class<?> returnType = method.getReturnType();
        if (Result.class != returnType) {
            return null;
        }
        if (!(this.cause instanceof FeignException)) {
            return Result.error((String)errorMessage);
        }
        FeignException exception = (FeignException)this.cause;
        Optional byteBuffer = exception.responseBody();
        if (byteBuffer.isEmpty()) {
            return Result.error((String)errorMessage);
        }
        return Result.error((String)byteBuffer.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShoreFeignFallback that = (ShoreFeignFallback)o;
        return this.targetType.equals(that.targetType);
    }

    public int hashCode() {
        return Objects.hash(this.targetType);
    }

    public ShoreFeignFallback(Class<T> targetType, String targetName, Throwable cause) {
        this.targetType = targetType;
        this.targetName = targetName;
        this.cause = cause;
    }
}

