/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.ide.aspect;

import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import me.youm.frame.common.exception.IdempotentException;
import me.youm.frame.common.utils.TokenUtil;
import me.youm.frame.ide.annotation.Idempotent;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.Redisson;
import org.redisson.api.RMapCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class IdeAspect {
    private static final Logger log = LoggerFactory.getLogger(IdeAspect.class);
    private ThreadLocal<Map<String, Object>> threadLocal = new ThreadLocal();
    private static final String RMAPCACHE_KEY = "idempotent";
    private static final String KEY = "key";
    private static final String DELKEY = "delKey";
    @Autowired
    private Redisson redisson;

    @Pointcut(value="@annotation(me.youm.frame.ide.annotation.Idempotent)")
    public void pointCut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before(value="pointCut()")
    public void beforePointCut(JoinPoint joinPoint) throws Exception {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (requestAttributes != null);
        HttpServletRequest request = requestAttributes.getRequest();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (!method.isAnnotationPresent(Idempotent.class)) {
            return;
        }
        Idempotent idempotent = method.getAnnotation(Idempotent.class);
        boolean isIdempotent = idempotent.isIdempotent();
        if (!isIdempotent) {
            return;
        }
        String url = request.getRequestURL().toString();
        String argString = Arrays.asList(joinPoint.getArgs()).toString();
        String header = request.getHeader("Mine-Auth");
        String token = "";
        if (StringUtils.hasText((String)header)) {
            token = TokenUtil.getToken((String)header);
        }
        String key = url + argString + token;
        long expireTime = idempotent.expireTime();
        String info = idempotent.info();
        TimeUnit timeUnit = idempotent.timeUnit();
        boolean delKey = idempotent.delKey();
        RMapCache rMapCache = this.redisson.getMapCache(RMAPCACHE_KEY);
        String value = LocalDateTime.now().toString().replace("T", " ");
        if (null != rMapCache.get((Object)key)) {
            throw new IdempotentException("[idempotent]:" + info);
        }
        IdeAspect ideAspect = this;
        synchronized (ideAspect) {
            Object v1 = rMapCache.putIfAbsent((Object)key, (Object)value, expireTime, TimeUnit.SECONDS);
            if (null != v1) {
                throw new IdempotentException("[idempotent]:" + info);
            }
            log.info("[idempotent]:has stored key={},value={},expireTime={}{},now={}", new Object[]{key, value, expireTime, timeUnit, LocalDateTime.now().toString()});
        }
        Map<Object, Object> map = CollectionUtils.isEmpty(this.threadLocal.get()) ? new HashMap(4) : this.threadLocal.get();
        map.put(KEY, key);
        map.put(DELKEY, delKey);
        this.threadLocal.set(map);
    }

    @After(value="pointCut()")
    public void afterPointCut(JoinPoint joinPoint) {
        Map<String, Object> map = this.threadLocal.get();
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        RMapCache mapCache = this.redisson.getMapCache(RMAPCACHE_KEY);
        if (mapCache.size() == 0) {
            return;
        }
        String key = map.get(KEY).toString();
        boolean delKey = (Boolean)map.get(DELKEY);
        if (delKey) {
            mapCache.fastRemove(new Object[]{key});
            log.info("[idempotent]:has removed key={}", (Object)key);
        }
        this.threadLocal.remove();
    }
}

