package me.youm.frame.jpa.base.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import me.youm.frame.jpa.listener.DataBaseAuditListener;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.Column;
import javax.persistence.EntityListeners;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * ID 为主键的泛型，子类继承需要指定ID的类型，这样将ID实现放在子类中，具有更广的适用性
 * @author youta
 */
@Getter
@Setter
@MappedSuperclass
@EntityListeners({AuditingEntityListener.class,DataBaseAuditListener.class})
@ApiModel(value = "基础实体", description = "所有数据表的通用部分")
public abstract class BaseEntity<ID> extends BaseSearchEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 获取id
     * @return ID
     */
    public abstract ID getId();

    /**
     * 设置ID
     * @param id id
     */
    public abstract void setId(ID id);

    /**
     * Description:创建日期,数据库底层实现时间的创建
     */
    @Column(updatable = false, columnDefinition = "datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间'")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @CreatedDate
    @ApiModelProperty(hidden = true)
    private LocalDateTime createTime;

    /**
     * Description:最后更新日期,数据底层实现时间的更新
     */
    @Column(columnDefinition = "datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP NULL COMMENT '更新时间'")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @LastModifiedDate
    @ApiModelProperty(hidden = true)
    private LocalDateTime updateTime;


    /**
     * Description:创建人编号
     */
    @Column(length = 32, columnDefinition = "varchar(32) COMMENT '创建人'")
    @CreatedBy
    @ApiModelProperty(hidden = true)
    private String createBy;

    /**
     * Description:更新人编号或者姓名,//不使用id，如果人员被删除，看到一个数字是无意义的。
     * 修改人
     */
    @Column(length = 32, columnDefinition = "varchar(32) COMMENT '更新人'")
    @LastModifiedBy
    @ApiModelProperty(hidden = true)
    private String updateBy;

}
