package me.youm.frame.jpa.base.repository;

import me.youm.frame.jpa.base.entity.BaseEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.repository.NoRepositoryBean;

import java.util.List;

/**
 * @author youta
 */
@NoRepositoryBean
public interface BaseRepository<T extends BaseEntity, ID> extends JpaRepository<T, ID>
//        , QuerydslPredicateExecutor<T>
{


    /**
     * Description:这是一个多条件动态查询的例子，类似Mybatis中动态sql的功能
     *
     * @param spec     高级条件
     * @param pageable 分页对象
     * @return 分页对象
     */
    Page<T> findAll(Specification<T> spec, Pageable pageable);


    /**
     * Description:使用条件查询，不分页
     *
     * @param spec 高级条件
     * @return 列表集合
     */
    List<T> findAll(Specification<T> spec);

    /**
     * Description:获取前25条数据
     *
     * @return 列表集合
     */
    List<T> findTop25ByOrderByIdDesc();
}
