package me.youm.frame.jpa.listener;

import lombok.extern.slf4j.Slf4j;
import me.youm.frame.common.exception.TokenException;
import me.youm.frame.security.utils.LoginUtil;
import org.springframework.stereotype.Component;

import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.lang.reflect.Field;

/**
 * @author youta
 */
@Component
@Slf4j
public class DataBaseAuditListener {

    /**
     * 新增数据时，填充创建人和创建时间
     */
    @PrePersist
    public void prePersist(Object object)
            throws IllegalArgumentException, IllegalAccessException {
        Class<?> aClass = object.getClass().getSuperclass();
        try {
            // 填充创建用户Id
            addUserName(object, aClass, "createBy");
        } catch (NoSuchFieldException e) {
            log.error("reflect failed：", e);
        }

    }

    /**
     * 更新数据时，填充更新人和更新时间
     */
    @PreUpdate
    public void preUpdate(Object object)
            throws IllegalArgumentException, IllegalAccessException {
        Class<?> aClass = object.getClass().getSuperclass();
        try {
            // 填充更新用户Id
            addUserName(object, aClass, "updateBy");
            // 填充更新时间
        } catch (NoSuchFieldException e) {
            log.error("reflect failed：", e);
        }
    }


    /**
     * 新增数据之后的操作
     */
    @PostPersist
    public void postPersist(Object object)
            throws IllegalArgumentException, IllegalAccessException {

    }

    /**
     * 更新数据之后的操作
     */
    @PostUpdate
    public void postUpdate(Object object)
            throws IllegalArgumentException, IllegalAccessException {
    }
    /**
     * 填充用户姓名
     *
     * @param object obj
     * @param aClass clz
     * @param propertyName 属性名（对应实体类中的属性）
     * @throws NoSuchFieldException no such field exception
     * @throws IllegalAccessException illegal exception
     */
    protected void addUserName(Object object, Class<?> aClass, String propertyName) throws NoSuchFieldException, IllegalAccessException {
        Field realName = aClass.getDeclaredField(propertyName);
        realName.setAccessible(true);
        Object userIdValue = realName.get(object);
        if (userIdValue == null) {
            realName.set(object, getUserName());
        }
    }


    /**
     * 获取 当前的用户名
     * @return 当前用户名
     */
    private String getUserName() {
        try {
            return LoginUtil.realName();
        }catch (TokenException e){
            return null;
        }
    }
}
