/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.jpa.base.controller;

import cn.hutool.core.util.StrUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.youm.frame.common.enums.CodeEnum;
import me.youm.frame.common.enums.SearchTypeEnum;
import me.youm.frame.common.model.IPage;
import me.youm.frame.common.model.Result;
import me.youm.frame.jpa.base.entity.BaseEntity;
import me.youm.frame.jpa.base.entity.BaseSearchField;
import me.youm.frame.jpa.base.service.IBaseService;
import me.youm.frame.jpa.utils.UpdatePoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BaseController<T1 extends BaseEntity, T2 extends IBaseService, ID> {
    private static final Logger log = LoggerFactory.getLogger(BaseController.class);
    @Autowired
    public T2 entityService;
    private Class<T1> clazz = null;

    public BaseController() {
        Class<?> clz = this.getClass();
        ParameterizedType type = (ParameterizedType)clz.getGenericSuperclass();
        Type[] types = type.getActualTypeArguments();
        this.clazz = (Class)types[0];
    }

    public Result<IPage> page(Pageable page) {
        Page entities = this.entityService.findAll(page);
        IPage IPage2 = new IPage(entities);
        return Result.ok((Object)IPage2);
    }

    public Result<IPage> advancedPageQuery(Pageable page, T1 entity) {
        Page<T1> entities = this.entityService.advancedQuery(entity, page);
        IPage IPage2 = new IPage(entities);
        return Result.ok((Object)IPage2);
    }

    public Result<?> advancedQuery(T1 entity) {
        return Result.ok(this.entityService.advancedQuery(entity));
    }

    public Result<?> queryMultiField(String q, String fields) {
        if (StringUtils.isEmpty((Object)fields)) {
            return Result.error((CodeEnum)CodeEnum.SELECT_PROPERTY_NAME_NOT_EMPTY);
        }
        T1 be = this.buildQueryConditions(q, fields);
        return Result.ok(this.entityService.advancedQuery(be));
    }

    public Result<?> queryMultiField(String q, String fields, Pageable page) {
        if (StringUtils.isEmpty((Object)fields)) {
            return Result.error((CodeEnum)CodeEnum.SELECT_PROPERTY_NAME_NOT_EMPTY);
        }
        T1 be = this.buildQueryConditions(q, fields);
        Page<T1> entities = this.entityService.advancedQuery(be, page);
        IPage iPage = new IPage(entities);
        return Result.ok((Object)iPage);
    }

    public Result<?> getById(ID id) {
        if (null == id) {
            return Result.error((CodeEnum)CodeEnum.KEY_NOT_NULL);
        }
        Optional entity = this.entityService.findById(id);
        if (entity.isPresent()) {
            return Result.ok(entity.get());
        }
        return Result.error((CodeEnum)CodeEnum.SELECT_NON_EXISTENT);
    }

    public Result<T1> save(T1 entity) {
        this.entityService.save(entity);
        return Result.ok(entity);
    }

    public Result<?> updateById(T1 entity) {
        Optional entityOptional = this.entityService.findById(((BaseEntity)entity).getId());
        if (!entityOptional.isPresent()) {
            return Result.error((CodeEnum)CodeEnum.UPDATE_NON_EXISTENT);
        }
        LocalDateTime updateTime = ((BaseEntity)entity).getUpdateTime();
        LocalDateTime dbUpdateTime = ((BaseEntity)entityOptional.get()).getUpdateTime();
        if (updateTime != null && updateTime.compareTo(dbUpdateTime) != 0) {
            return Result.error((CodeEnum)CodeEnum.UPDATE_NEW_BY_OLD_NOT_ALLOWED);
        }
        if (null != ((BaseEntity)entity).getId()) {
            this.updateEntity((BaseEntity)entityOptional.get(), entity, false, "createTime", "updateTime");
        }
        return Result.ok(entity);
    }

    public Result<?> deleteById(ID id) {
        if (null == id) {
            return Result.error((CodeEnum)CodeEnum.KEY_NOT_NULL);
        }
        Optional entity = this.entityService.findById(id);
        if (!entity.isPresent()) {
            return Result.error((CodeEnum)CodeEnum.DELETE_NON_EXISTENT);
        }
        try {
            this.entityService.deleteById(id);
        }
        catch (Exception e) {
            return Result.error((String)e.getMessage());
        }
        return Result.ok(id);
    }

    public Result deleteByIds(Set<ID> entityIds) {
        if (CollectionUtils.isEmpty(entityIds)) {
            return Result.ok();
        }
        try {
            this.entityService.deleteAllById(entityIds);
        }
        catch (Exception e) {
            return Result.error((String)e.getMessage());
        }
        return Result.ok();
    }

    public Boolean chkEntityIdExist(ID entityId) {
        return null != entityId && this.entityService.existsById(entityId);
    }

    public Result getPropertySet(String property, String value) {
        if (StringUtils.isEmpty((Object)property)) {
            return Result.error((CodeEnum)CodeEnum.SELECT_PROPERTY_NOT_EMPTY);
        }
        return Result.ok((Object)this.entityService.advanceSearchProperty(property, value));
    }

    private T1 updateEntity(T1 dbEntity, T1 entity, Boolean useNull, String ... ignoreProperties) {
        if (!useNull.booleanValue()) {
            UpdatePoUtil.copyNullProperties(dbEntity, entity, ignoreProperties);
        }
        return this.entityService.update(entity);
    }

    private T1 buildQueryConditions(String q, String fields) {
        BaseEntity entity = (BaseEntity)this.clazz.newInstance();
        if (!StrUtil.isAllEmpty((CharSequence[])new CharSequence[]{q, fields})) {
            String[] rawFields;
            HashSet<BaseSearchField> conditions = new HashSet<BaseSearchField>();
            for (String c : rawFields = fields.split(",|;|\u3001|\uff0c|\uff1b")) {
                BaseSearchField condition = new BaseSearchField();
                condition.setName(c);
                condition.setSearchType(SearchTypeEnum.FUZZY.getValue());
                condition.setVal(q);
                conditions.add(condition);
            }
            entity.setConditions(conditions);
            return (T1)entity;
        }
        return null;
    }
}

