/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.jpa.base.service.impl;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import me.youm.frame.common.enums.ConditionRelationEnum;
import me.youm.frame.common.enums.SearchTypeEnum;
import me.youm.frame.common.utils.MapUtils;
import me.youm.frame.jpa.base.entity.BaseEntity;
import me.youm.frame.jpa.base.entity.BaseSearchEntity;
import me.youm.frame.jpa.base.entity.BaseSearchField;
import me.youm.frame.jpa.base.repository.BaseRepository;
import me.youm.frame.jpa.base.service.IBaseService;
import me.youm.frame.jpa.utils.SqlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Transactional
public class BaseServiceImpl<T extends BaseEntity, ID, BR extends BaseRepository>
extends Observable
implements IBaseService<T, ID>,
Observer {
    private static final Logger log = LoggerFactory.getLogger(BaseServiceImpl.class);
    private final String DEFAULT_GROUP_NAME = "DEFAULT_NO_GROUP";
    @PersistenceContext
    protected EntityManager em;
    protected Class<T> clazz = null;
    @Autowired
    public BR br;

    public BaseServiceImpl() {
        Class<?> clz = this.getClass();
        ParameterizedType type = (ParameterizedType)clz.getGenericSuperclass();
        Type[] types = type.getActualTypeArguments();
        this.clazz = (Class)types[0];
    }

    @Override
    public Iterable<T> findAll() {
        return this.br.findAll();
    }

    @Override
    public Page<T> findAll(Pageable var1) {
        return this.br.findAll(var1);
    }

    @Override
    public Iterable<T> findAll(Sort var1) {
        return this.br.findAll(var1);
    }

    @Override
    public Iterable<T> findAllById(Iterable<ID> var1) {
        return this.br.findAllById(var1);
    }

    @Override
    public T getOne(ID id) {
        return (T)((BaseEntity)this.br.getOne(id));
    }

    @Override
    public Optional<T> findById(ID var1) {
        return this.br.findById(var1);
    }

    @Override
    public <S extends T> Optional<S> findOne(Example<S> example) {
        return this.br.findOne(example);
    }

    @Override
    public <S extends T> List<S> findAll(Example<S> var1) {
        return this.br.findAll(var1);
    }

    @Override
    public <S extends T> List<S> findAll(Example<S> var1, Sort var2) {
        return this.br.findAll(var1, var2);
    }

    @Override
    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        return this.br.findAll(example, pageable);
    }

    @Override
    public <S extends T> Iterable<S> saveAll(Iterable<S> var1) {
        return this.br.saveAll(var1);
    }

    @Override
    public void flush() {
        this.br.flush();
    }

    @Override
    public <S extends T> S saveAndFlush(S var1) {
        return (S)((BaseEntity)this.br.saveAndFlush(var1));
    }

    @Override
    public <S extends T> S save(S var1) {
        return (S)((BaseEntity)this.br.save(var1));
    }

    @Override
    public void delete(T var1) {
        this.br.delete(var1);
    }

    @Override
    public void deleteById(ID var1) {
        this.br.deleteById(var1);
    }

    @Override
    public void deleteAll() {
        this.br.deleteAll();
    }

    @Override
    public void deleteAll(Iterable<? extends T> var1) {
        this.br.deleteAll(var1);
    }

    @Override
    public void deleteAllInBatch() {
        this.br.deleteAllInBatch();
    }

    @Override
    public void deleteInBatch(Iterable<T> var1) {
        this.br.deleteInBatch(var1);
    }

    @Override
    public boolean existsById(ID var1) {
        return this.br.existsById(var1);
    }

    @Override
    public long count() {
        return this.br.count();
    }

    @Override
    public <S extends T> long count(Example<S> example) {
        return this.br.count(example);
    }

    @Override
    public <S extends T> boolean exists(Example<S> example) {
        return this.br.exists(example);
    }

    @Override
    public boolean existsByEntityProperty(String propertyName, String propertyValue) throws NoSuchFieldException {
        if (this.isPropertyIllegal(propertyName)) {
            throw new NoSuchFieldException(propertyName + "\u4e0d\u5b58\u5728\uff01");
        }
        Set resultSet = this.advanceSearchProperty(propertyName, propertyValue);
        return resultSet.size() > 0;
    }

    @Override
    public int deleteAllById(Iterable<ID> var1) {
        String hql = "delete from " + this.clazz.getSimpleName() + " t where t.id in (?1)";
        Query query = this.em.createQuery(hql);
        query.setParameter(1, var1);
        int result = query.executeUpdate();
        return result;
    }

    @Override
    public <S extends T> S update(S var1) {
        return (S)((BaseEntity)this.br.save(var1));
    }

    @Override
    public List<T> advancedQuery(T entity) {
        if (((BaseSearchEntity)entity).getConditions() != null && ((BaseSearchEntity)entity).getConditions().size() > 0) {
            return this.br.findAll(this.getSpecification(entity));
        }
        return this.br.findTop25ByOrderByIdDesc();
    }

    @Override
    public Page<T> advancedQuery(T entity, Pageable pageable) {
        if (((BaseSearchEntity)entity).getConditions() != null && ((BaseSearchEntity)entity).getConditions().size() > 0) {
            Specification<T> specification = this.getSpecification(entity);
            return this.br.findAll(specification, pageable);
        }
        return this.br.findAll(pageable);
    }

    @Override
    public Set advanceSearchProperty(String property, String value) {
        if (this.isPropertyIllegal(property)) {
            return new HashSet();
        }
        Specification<Object> specification = this.getSpec4PropSetByLike(property, value);
        List<Object> result = this.br.findAll(specification);
        if (result != null && result.size() > 0) {
            return new TreeSet<Object>(result);
        }
        return new TreeSet();
    }

    private void checkPropertyAndValueValidity(T entity) {
        Set<BaseSearchField> conditions = ((BaseSearchEntity)entity).getConditions();
        if (conditions == null || conditions.size() == 0) {
            return;
        }
        HashSet illegalConditions = new HashSet();
        Map properties = MapUtils.objectToMap1(entity);
        Set keys = properties.keySet();
        conditions.forEach(condition -> {
            if (!keys.contains(condition.getName())) {
                illegalConditions.add(condition);
            }
        });
        conditions.removeAll(illegalConditions);
        conditions.forEach(condition -> {
            String value2;
            int searchType;
            String value1 = condition.getVal();
            if (SqlFilter.sqlInject(value1).booleanValue()) {
                illegalConditions.add(condition);
            }
            int n = searchType = condition.getSearchType() == null ? 0 : condition.getSearchType();
            if (SearchTypeEnum.RANGE.getValue() == searchType && SqlFilter.sqlInject(value2 = condition.getVal2()).booleanValue()) {
                illegalConditions.add(condition);
            }
        });
        conditions.removeAll(illegalConditions);
    }

    private Specification<T> getSpecification(T entity) {
        Set<BaseSearchField> conditions = ((BaseSearchEntity)entity).getConditions();
        this.checkPropertyAndValueValidity(entity);
        Map<String, List<BaseSearchField>> groups = this.checkHasGroup(conditions);
        if (groups.size() == 1) {
            return this.handleSingleGroupCondition(groups.get("DEFAULT_NO_GROUP"), entity);
        }
        return this.handleGroupsCondition(groups, entity);
    }

    private Specification<Object> getSpec4PropSetByLike(final String property, final String value) {
        return new Specification<Object>(){

            public Predicate toPredicate(Root<Object> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path pp = root.get(property);
                Predicate predicate = cb.like((Expression)pp, "%" + value + "%");
                query.where((Expression)predicate);
                query.select((Selection)pp);
                query.distinct(true);
                Predicate restriction = query.getRestriction();
                return restriction;
            }
        };
    }

    private String getPropTypeString(String key, T entity) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = entity.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
        }
        for (Field field : fieldList) {
            if (!field.getName().equals(key)) continue;
            return field.getType().getSimpleName();
        }
        return "";
    }

    private Class<?> getPropType(String key, T entity) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = entity.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
        }
        for (Field field : fieldList) {
            if (!field.getName().equals(key)) continue;
            return field.getType();
        }
        return null;
    }

    private boolean isPropertyIllegal(String property) {
        Map properties = MapUtils.objectToMap1(this.clazz.newInstance());
        return !properties.keySet().contains(property);
    }

    private Specification<T> handleGroupsCondition(final Map<String, List<BaseSearchField>> groups, T entity) {
        return new Specification<T>((BaseEntity)entity){
            final /* synthetic */ BaseEntity val$entity;
            {
                this.val$entity = baseEntity;
            }

            public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Predicate defaultGroupP = BaseServiceImpl.this.genPredicate4SingleGroup((List)groups.get("DEFAULT_NO_GROUP"), root, cb, this.val$entity);
                for (Map.Entry entry : groups.entrySet()) {
                    Predicate tmpGroupP;
                    if ("DEFAULT_NO_GROUP".equalsIgnoreCase((String)entry.getKey()) || (tmpGroupP = BaseServiceImpl.this.genPredicate4SingleGroup((List)entry.getValue(), root, cb, this.val$entity)) == null) continue;
                    if (defaultGroupP == null) {
                        defaultGroupP = tmpGroupP;
                        continue;
                    }
                    Integer logicalTypeGroup = ((BaseSearchField)((List)entry.getValue()).get(0)).getLogicalTypeGroup();
                    if (logicalTypeGroup.intValue() == ConditionRelationEnum.AND.getValue()) {
                        defaultGroupP = cb.and((Expression)defaultGroupP, (Expression)tmpGroupP);
                        continue;
                    }
                    defaultGroupP = cb.or((Expression)defaultGroupP, (Expression)tmpGroupP);
                }
                return defaultGroupP;
            }
        };
    }

    private Specification<T> handleSingleGroupCondition(final List<BaseSearchField> fields, T entity) {
        return new Specification<T>((BaseEntity)entity){
            final /* synthetic */ BaseEntity val$entity;
            {
                this.val$entity = baseEntity;
            }

            public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return BaseServiceImpl.this.genPredicate4SingleGroup(fields, root, cb, this.val$entity);
            }
        };
    }

    private Predicate genPredicate4SingleGroup(List<BaseSearchField> fields, Root<T> root, CriteriaBuilder cb, T entity) {
        Predicate finalPredicat = null;
        int count = fields.size();
        Predicate fieldP = null;
        for (int i = 0; i < count; ++i) {
            Integer logicalType;
            BaseSearchField field = fields.get(i);
            int searchType = field.getSearchType() == null ? 0 : field.getSearchType();
            String key = field.getName();
            String startVal = field.getVal();
            String endVal = field.getVal2();
            String fieldTypeString = this.getPropTypeString(key, entity);
            Class<?> fieldType = this.getPropType(key, entity);
            switch (searchType) {
                case 1: {
                    if (!"String".equalsIgnoreCase(fieldTypeString)) {
                        fieldP = cb.equal(root.get(key).as(fieldType), (Object)startVal);
                        break;
                    }
                    fieldP = cb.equal(root.get(key).as(String.class), (Object)startVal);
                    break;
                }
                case 2: {
                    if (!"String".equalsIgnoreCase(fieldTypeString)) {
                        String end = endVal;
                        String start = startVal;
                        fieldP = end.compareTo(start) > 0 ? cb.between(root.get(key).as(fieldType), (Comparable)((Object)start), (Comparable)((Object)end)) : cb.between(root.get(key).as(fieldType), (Comparable)((Object)end), (Comparable)((Object)start));
                        break;
                    }
                    fieldP = cb.between(root.get(key).as(String.class), (Comparable)((Object)startVal), (Comparable)((Object)endVal));
                    break;
                }
                case 3: {
                    if (!"String".equalsIgnoreCase(fieldTypeString)) {
                        fieldP = cb.notEqual((Expression)root.get(key), (Object)startVal);
                        break;
                    }
                    fieldP = cb.notEqual((Expression)root.get(key), (Object)startVal);
                    break;
                }
                case 4: {
                    if (!"String".equalsIgnoreCase(fieldTypeString)) {
                        fieldP = cb.lessThan(root.get(key).as(fieldType), (Comparable)((Object)startVal));
                        break;
                    }
                    fieldP = cb.lessThan(root.get(key).as(String.class), (Comparable)((Object)startVal));
                    break;
                }
                case 5: {
                    if (!"String".equalsIgnoreCase(fieldTypeString)) {
                        fieldP = cb.lessThanOrEqualTo(root.get(key).as(fieldType), (Comparable)((Object)startVal));
                        break;
                    }
                    fieldP = cb.lessThanOrEqualTo(root.get(key).as(String.class), (Comparable)((Object)startVal));
                    break;
                }
                case 6: {
                    if (!"String".equalsIgnoreCase(fieldTypeString)) {
                        fieldP = cb.greaterThan(root.get(key).as(fieldType), (Comparable)((Object)startVal));
                        break;
                    }
                    fieldP = cb.greaterThan(root.get(key).as(String.class), (Comparable)((Object)startVal));
                    break;
                }
                case 7: {
                    if (!"String".equalsIgnoreCase(fieldTypeString)) {
                        fieldP = cb.greaterThanOrEqualTo(root.get(key).as(fieldType), (Comparable)((Object)startVal));
                        break;
                    }
                    fieldP = cb.greaterThanOrEqualTo(root.get(key).as(String.class), (Comparable)((Object)startVal));
                    break;
                }
                case 8: {
                    fieldP = cb.isNull((Expression)root.get(key));
                    break;
                }
                case 9: {
                    fieldP = cb.isNotNull((Expression)root.get(key));
                    break;
                }
                case 10: {
                    fieldP = cb.like(root.get(key).as(String.class), "%" + startVal);
                    break;
                }
                case 11: {
                    fieldP = cb.like(root.get(key).as(String.class), startVal + "%");
                    break;
                }
                case 12: {
                    String[] values = startVal.split(",|;|\u3001|\uff0c|\uff1b");
                    List<String> valueList = Arrays.asList(values);
                    if (!"String".equalsIgnoreCase(fieldTypeString)) {
                        ArrayList valueDateList = new ArrayList();
                        valueList.forEach(v -> valueDateList.add(v));
                        Path exp = root.get(key);
                        fieldP = exp.in(valueDateList);
                        break;
                    }
                    Path exp = root.get(key);
                    fieldP = exp.in(valueList);
                    break;
                }
                default: {
                    fieldP = cb.like(root.get(key).as(String.class), "%" + startVal + "%");
                }
            }
            finalPredicat = i == 0 ? fieldP : ((logicalType = field.getLogicalType()).intValue() == ConditionRelationEnum.AND.getValue() ? cb.and((Expression)finalPredicat, (Expression)fieldP) : cb.or((Expression)finalPredicat, (Expression)fieldP));
        }
        return finalPredicat;
    }

    private Map<String, List<BaseSearchField>> checkHasGroup(Set<BaseSearchField> conditions) {
        HashMap<String, List<BaseSearchField>> groups = new HashMap<String, List<BaseSearchField>>();
        groups.put("DEFAULT_NO_GROUP", new ArrayList());
        for (BaseSearchField baseSearchField : conditions) {
            String groupName = baseSearchField.getBracketsGroup();
            if (StringUtils.isEmpty((Object)groupName)) {
                ((List)groups.get("DEFAULT_NO_GROUP")).add(baseSearchField);
                continue;
            }
            if (groups.get(groupName) == null) {
                groups.put(groupName, new ArrayList());
            }
            ((List)groups.get(groupName)).add(baseSearchField);
        }
        for (Map.Entry entry : groups.entrySet()) {
            ((List)entry.getValue()).sort(Comparator.comparingInt(BaseSearchField::getOrder));
        }
        return groups;
    }

    @Override
    public void registObservers(Observer ... observers) {
        for (Observer observer : observers) {
            this.addObserver(observer);
        }
    }

    @Override
    public void notifyOthers(Object arg) {
        this.setChanged();
        this.notifyObservers(arg);
    }

    @Override
    public void update(Observable o, Object arg) {
    }
}

