/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.jpa.listener;

import java.lang.reflect.Field;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import me.youm.frame.common.exception.TokenException;
import me.youm.frame.security.utils.LoginUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataBaseAuditListener {
    private static final Logger log = LoggerFactory.getLogger(DataBaseAuditListener.class);

    @PrePersist
    public void prePersist(Object object) throws IllegalArgumentException, IllegalAccessException {
        Class<?> aClass = object.getClass().getSuperclass();
        try {
            this.addUserName(object, aClass, "createBy");
        }
        catch (NoSuchFieldException e) {
            log.error("reflect failed\uff1a", (Throwable)e);
        }
    }

    @PreUpdate
    public void preUpdate(Object object) throws IllegalArgumentException, IllegalAccessException {
        Class<?> aClass = object.getClass().getSuperclass();
        try {
            this.addUserName(object, aClass, "updateBy");
        }
        catch (NoSuchFieldException e) {
            log.error("reflect failed\uff1a", (Throwable)e);
        }
    }

    @PostPersist
    public void postPersist(Object object) throws IllegalArgumentException, IllegalAccessException {
    }

    @PostUpdate
    public void postUpdate(Object object) throws IllegalArgumentException, IllegalAccessException {
    }

    protected void addUserName(Object object, Class<?> aClass, String propertyName) throws NoSuchFieldException, IllegalAccessException {
        Field realName = aClass.getDeclaredField(propertyName);
        realName.setAccessible(true);
        Object userIdValue = realName.get(object);
        if (userIdValue == null) {
            realName.set(object, this.getUserName());
        }
    }

    private String getUserName() {
        try {
            return LoginUtil.realName();
        }
        catch (TokenException e) {
            return null;
        }
    }
}

