package me.youm.frame.lock;

import me.youm.frame.lock.aspect.LockAspect;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author youta
 */
@Configuration(proxyBeanMethods = false)
@AutoConfigureAfter(RedisAutoConfiguration.class)
public class LockAutoConfiguration {

    /**
     * 切面 拦截处理所有 @ShoreLock
     * @return Aspect
     */
    @Bean
    public LockAspect lockAspect() {
        return new LockAspect();
    }

}
