/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.lock.aspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URI;
import java.time.Duration;
import javax.annotation.Resource;
import me.youm.frame.common.context.ReactiveRequestContextHolder;
import me.youm.frame.common.exception.IdempotentException;
import me.youm.frame.common.utils.SecurityUtil;
import me.youm.frame.lock.annotation.ShoreLock;
import me.youm.frame.redis.reactive.service.ReactiveRedisService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Aspect
public class LockAspect {
    private static final Logger log = LoggerFactory.getLogger(LockAspect.class);
    public static final String REQUEST_KEY = "RequestKey:";
    @Resource
    private ReactiveRedisService reactiveRedisService;

    @Pointcut(value="@annotation(me.youm.frame.lock.annotation.ShoreLock)")
    public void myPoint() {
    }

    @Around(value="myPoint()")
    public Mono<?> apiIdempotentCheck(ProceedingJoinPoint pjp) throws Throwable {
        Signature signature = pjp.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        Mono mono = (Mono)pjp.proceed();
        ShoreLock annotation = method.getAnnotation(ShoreLock.class);
        if (annotation == null) {
            return mono;
        }
        return ReactiveRequestContextHolder.getExchange().flatMap(serverWebExchange -> this.check((ServerWebExchange)serverWebExchange, pjp.getArgs().length == 0 ? null : pjp.getArgs()[0], method, (Mono<?>)mono));
    }

    private Mono<?> check(ServerWebExchange serverWebExchange, Object arg, Method method, Mono<?> mono) {
        String parameterName;
        URI uri = serverWebExchange.getRequest().getURI();
        String token = SecurityUtil.getHeaderToken((ServerWebExchange)serverWebExchange);
        String apiMethodName = method.getName();
        Parameter[] parameters = method.getParameters();
        Annotation[] declaredAnnotations = method.getDeclaredAnnotations();
        String apiName = this.getRequestName(uri, declaredAnnotations);
        if (parameters.length > 0) {
            Parameter parameter = parameters[0];
            parameterName = parameter.getName();
        } else {
            parameterName = "";
            if (StringUtils.hasText((String)token)) {
                parameterName = token;
            }
        }
        ShoreLock annotation = method.getAnnotation(ShoreLock.class);
        long l = annotation.expireTime();
        Object key = StringUtils.hasText((String)annotation.key()) ? annotation.key() : "RequestKey::" + apiName + ":" + apiMethodName + ":" + parameterName;
        return this.reactiveRedisService.hasKey((String)key).flatMap(arg_0 -> this.lambda$check$1(annotation, arg, (String)key, l, arg_0)).flatMap(arg_0 -> this.lambda$check$2(annotation, (String)key, mono, arg_0));
    }

    private String getRequestName(URI requestURI, Annotation[] declaredAnnotations) {
        String apiName = null;
        for (Annotation declaredAnnotation : declaredAnnotations) {
            if (declaredAnnotation instanceof RequestMapping) {
                RequestMapping requestMapping = (RequestMapping)declaredAnnotation;
                String requestType = requestMapping.method()[0].name();
                apiName = requestType + ":" + requestURI;
            }
            if (declaredAnnotation instanceof DeleteMapping) {
                apiName = "DELETE:" + requestURI;
            }
            if (declaredAnnotation instanceof GetMapping) {
                apiName = "GET:" + requestURI;
            }
            if (declaredAnnotation instanceof PutMapping) {
                apiName = "PUT:" + requestURI;
            }
            if (!(declaredAnnotation instanceof PostMapping)) continue;
            apiName = "POST:" + requestURI;
        }
        return apiName;
    }

    private /* synthetic */ Mono lambda$check$2(ShoreLock annotation, String key, Mono mono, Boolean x) {
        if (annotation.delKey()) {
            return this.reactiveRedisService.del(key);
        }
        return mono;
    }

    private /* synthetic */ Mono lambda$check$1(ShoreLock annotation, Object arg, String key, long l, Boolean aBoolean) {
        if (aBoolean.booleanValue()) {
            return Mono.error((Throwable)new IdempotentException(annotation.info()));
        }
        if (arg != null && !"".equals(arg)) {
            return this.reactiveRedisService.set(key, (Object)arg.toString(), Duration.ofSeconds(l));
        }
        return this.reactiveRedisService.set(key, (Object)"1", Duration.ofSeconds(l));
    }
}

