/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.oss.util;

import cn.hutool.core.bean.OptionalBean;
import cn.hutool.core.util.IdUtil;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import me.youm.frame.common.enums.CodeEnum;
import me.youm.frame.common.exception.AliOssException;
import me.youm.frame.oss.props.OssProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Component
public class OssUtil {
    private static final Logger log = LoggerFactory.getLogger(OssUtil.class);
    private final OSS ossClient;
    private final OssProperties ossProperties;
    private static final long FILE_LIMIT_SIZE = 0x1400000L;
    private static final String BMP = ".bmp";
    private static final String GIF = ".gif";
    private static final String JPEG = ".jpeg";
    private static final String JPG = ".jpg";
    private static final String PNG = ".png";
    private static final String HTML = ".html";
    private static final String TXT = ".txt";
    private static final String VSD = ".vsd";
    private static final String PPT = ".ppt";
    private static final String PPTX = ".pptx";
    private static final String DOCX = ".docx";
    private static final String DOC = ".doc";
    private static final String XML = ".xml";

    public String singleFileUpload(MultipartFile file, String bucketName, String fileDir) {
        if (file == null) {
            throw new AliOssException(HttpStatus.BAD_REQUEST.value(), "\u6587\u4ef6\u662f\u7a7a\u7684");
        }
        if (file.getSize() >= 0x1400000L) {
            throw new AliOssException(CodeEnum.FILE_SIZE_TOO_LONG_ERROR.getCode(), CodeEnum.FILE_SIZE_TOO_LONG_ERROR.getMsg());
        }
        if (!this.ossClient.doesBucketExist(bucketName)) {
            throw new AliOssException(CodeEnum.BUCKET_NOT_EXIST.getCode(), CodeEnum.BUCKET_NOT_EXIST.getMsg());
        }
        fileDir = StringUtils.hasText((String)fileDir) ? (String)fileDir + "/" : "";
        String originalFilename = file.getOriginalFilename();
        originalFilename = (String)OptionalBean.ofNullable((Object)originalFilename).get();
        String substring = originalFilename.substring(originalFilename.lastIndexOf(".")).toLowerCase();
        String name = IdUtil.simpleUUID() + substring;
        try {
            InputStream inputStream = file.getInputStream();
            this.uploadFile2Oss(inputStream, name, bucketName, (String)fileDir);
            String endpoint = this.ossProperties.getEndpoint();
            String str = ((String)OptionalBean.ofNullable((Object)endpoint).get()).split("//")[1] + "/";
            return "https://" + bucketName + "." + str + (String)fileDir + name;
        }
        catch (Exception e) {
            throw new AliOssException(CodeEnum.FILE_UPLOAD_ERROR.getCode(), CodeEnum.FILE_UPLOAD_ERROR.getMsg());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFile2Oss(InputStream inputStream, String fileName, String bucketName, String fileDir) {
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)inputStream.available());
            objectMetadata.setCacheControl("no-cache");
            objectMetadata.setHeader("Pragma", (Object)"no-cache");
            objectMetadata.setContentType(OssUtil.getContentType(fileName.substring(fileName.lastIndexOf("."))));
            objectMetadata.setContentDisposition("inline;filename=" + fileName);
            this.ossClient.putObject(bucketName, fileDir + fileName, inputStream, objectMetadata);
        }
        catch (OSSException ossException) {
            log.error("upload file failed by ossException", (Throwable)ossException);
            String errorCode = ossException.getErrorCode();
            throw new AliOssException(CodeEnum.ALI_YUN_OSS_ERROR.getCode(), errorCode);
        }
        catch (ClientException clientException) {
            log.error("upload file failed by clientException", (Throwable)clientException);
            String errorCode = clientException.getErrorCode();
            throw new AliOssException(CodeEnum.ALI_YUN_OSS_ERROR.getCode(), errorCode);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error("io error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile2Oss(InputStream inputStream, String fileName, String bucketName) {
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)inputStream.available());
            objectMetadata.setCacheControl("no-cache");
            objectMetadata.setHeader("Pragma", (Object)"no-cache");
            objectMetadata.setContentType("image/jpeg");
            objectMetadata.setContentDisposition("inline;filename=" + fileName);
            PutObjectResult putResult = this.ossClient.putObject(bucketName, fileName, inputStream, objectMetadata);
            putResult.getETag();
        }
        catch (OSSException ossException) {
            log.error("upload file failed by ossException", (Throwable)ossException);
            String string = ossException.getErrorCode();
        }
        catch (ClientException clientException) {
            log.error("upload file failed by clientException", (Throwable)clientException);
            String string = clientException.getErrorCode();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error("io error", (Throwable)e);
            }
        }
    }

    public static String getContentType(String fileNameExtension) {
        if (BMP.equalsIgnoreCase(fileNameExtension)) {
            return "image/bmp";
        }
        if (GIF.equalsIgnoreCase(fileNameExtension)) {
            return "image/gif";
        }
        if (JPEG.equalsIgnoreCase(fileNameExtension) || JPG.equalsIgnoreCase(fileNameExtension) || PNG.equalsIgnoreCase(fileNameExtension)) {
            return "image/jpeg";
        }
        if (HTML.equalsIgnoreCase(fileNameExtension)) {
            return "text/html";
        }
        if (TXT.equalsIgnoreCase(fileNameExtension)) {
            return "text/plain";
        }
        if (VSD.equalsIgnoreCase(fileNameExtension)) {
            return "application/vnd.visio";
        }
        if (PPTX.equalsIgnoreCase(fileNameExtension) || PPT.equalsIgnoreCase(fileNameExtension)) {
            return "application/vnd.ms-powerpoint";
        }
        if (DOCX.equalsIgnoreCase(fileNameExtension) || DOC.equalsIgnoreCase(fileNameExtension)) {
            return "application/msword";
        }
        if (XML.equalsIgnoreCase(fileNameExtension)) {
            return "text/xml";
        }
        return "image/jpeg";
    }

    public String batchFileUpload(List<MultipartFile> fileList, String bucketName, String fileDir) {
        fileDir = StringUtils.isEmpty((Object)fileDir) ? "" : (String)fileDir + "/";
        StringBuilder photoUrl = new StringBuilder();
        for (int i = 0; i < fileList.size(); ++i) {
            String fileUrl = this.singleFileUpload(fileList.get(i), bucketName, (String)fileDir);
            if (i == 0) {
                photoUrl = new StringBuilder(fileUrl);
                continue;
            }
            photoUrl.append(",").append(fileUrl);
        }
        return photoUrl.toString().trim();
    }

    public List<String> getAllBuckets() {
        List buckets = this.ossClient.listBuckets();
        buckets = (List)OptionalBean.ofNullable((Object)buckets).get();
        return buckets.stream().map(Bucket::getName).collect(Collectors.toList());
    }

    public void addBucket(String bucketName) {
        try {
            this.ossClient.createBucket(bucketName);
        }
        catch (OSSException ossException) {
            log.error("create bucket failed by ossException", (Throwable)ossException);
            String errorCode = ossException.getErrorCode();
            throw new AliOssException(CodeEnum.ALI_YUN_OSS_ERROR.getCode(), errorCode);
        }
        catch (ClientException clientException) {
            log.error("create bucket failed by clientException", (Throwable)clientException);
            String errorCode = clientException.getErrorCode();
            throw new AliOssException(CodeEnum.ALI_YUN_OSS_ERROR.getCode(), errorCode);
        }
    }

    public OssUtil(OSS ossClient, OssProperties ossProperties) {
        this.ossClient = ossClient;
        this.ossProperties = ossProperties;
    }
}

