/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.security.filter;

import me.youm.frame.common.utils.ResponseUtil;
import me.youm.frame.common.utils.TokenUtil;
import me.youm.frame.redis.service.ReactiveRedisService;
import me.youm.frame.security.props.TokenProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

@Component
public class SecurityFilter
implements WebFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(SecurityFilter.class);
    private final TokenProperties properties;
    private final ReactiveRedisService reactiveRedisService;

    @NonNull
    public Mono<Void> filter(@NonNull ServerWebExchange exchange, @NonNull WebFilterChain chain) {
        if (!this.properties.getEnable().booleanValue()) {
            return chain.filter(exchange);
        }
        String path = exchange.getRequest().getURI().getPath();
        String requestUrl = exchange.getRequest().getURI().getRawPath();
        if (this.ignore(path) || this.ignore(requestUrl)) {
            return chain.filter(exchange);
        }
        ServerHttpResponse resp = exchange.getResponse();
        String headerToken = exchange.getRequest().getHeaders().getFirst("Mine-Auth");
        if (headerToken == null) {
            return this.unauthorized(resp, "\u6ca1\u6709\u643a\u5e26Token\u4fe1\u606f");
        }
        String token = TokenUtil.getToken((String)headerToken);
        return this.reactiveRedisService.hasKey("Mine-Auth:login:token:" + token).flatMap(aBoolean -> {
            if (!aBoolean.booleanValue()) {
                return this.unauthorized(resp, "\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            }
            return chain.filter(exchange);
        });
    }

    private Mono<Void> unauthorized(ServerHttpResponse resp, String msg) {
        return ResponseUtil.webFluxResponseWriter((ServerHttpResponse)resp, (String)"application/json;charset=UTF-8", (HttpStatus)HttpStatus.UNAUTHORIZED, (Object)msg);
    }

    private boolean ignore(String path) {
        return this.properties.getIgnoreUrl().stream().map(url -> url.replace("/**", "")).anyMatch(path::startsWith);
    }

    public int getOrder() {
        return -200;
    }

    public SecurityFilter(TokenProperties properties, ReactiveRedisService reactiveRedisService) {
        this.properties = properties;
        this.reactiveRedisService = reactiveRedisService;
    }
}

