/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.security.aspect;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import me.youm.frame.common.exception.AuthorityException;
import me.youm.frame.security.annotation.PreAuth;
import me.youm.frame.security.context.CurrentUserContext;
import me.youm.frame.security.enums.SuperAdmin;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

@Aspect
@Component
public class PreAuthAspect {
    private static final Logger log = LoggerFactory.getLogger(PreAuthAspect.class);
    private static final String ALL_PERMISSION = "*:*:*";

    @Around(value="@annotation(me.youm.frame.security.annotation.PreAuth)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        PreAuth preAuth = method.getAnnotation(PreAuth.class);
        if (ObjectUtils.isEmpty((Object)preAuth)) {
            return point.proceed();
        }
        String perm = preAuth.hasPerm();
        if (!StringUtils.hasText((String)perm)) {
            return point.proceed();
        }
        Mono mono = (Mono)point.proceed();
        return CurrentUserContext.reactiveUser().flatMap(tokenInfo -> {
            if (tokenInfo.getUserName().equalsIgnoreCase(SuperAdmin.SUPER_ADMIN.getValue()) || tokenInfo.getUserName().equalsIgnoreCase(SuperAdmin.ADMIN.getValue())) {
                return mono;
            }
            if (StringUtils.hasText((String)perm) && !this.hasPermissions(Arrays.stream(String.valueOf(tokenInfo.getAuthorities()).split(",")).collect(Collectors.toList()), perm)) {
                return Mono.error((Throwable)new AuthorityException("\u65e0\u6743\u8bbf\u95ee"));
            }
            return mono;
        });
    }

    private boolean hasPermissions(Collection<String> authorities, String permission) {
        return authorities.stream().filter(StringUtils::hasText).anyMatch(x -> ALL_PERMISSION.contains((CharSequence)x) || PatternMatchUtils.simpleMatch((String)permission, (String)x));
    }
}

