/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.security.context;

import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.SaTokenInfo;
import cn.dev33.satoken.stp.StpUtil;
import java.io.Serializable;
import me.youm.frame.common.context.ReactiveRequestContextHolder;
import me.youm.frame.common.entity.TokenInfo;
import me.youm.frame.common.exception.TokenException;
import me.youm.frame.common.utils.SecurityUtil;
import reactor.core.publisher.Mono;

public class CurrentUserContext
implements Serializable {
    private static final String USER_SESSION_ID = "user";

    public static SaTokenInfo login(String username) {
        StpUtil.login((Object)username);
        return StpUtil.getTokenInfo();
    }

    public static void logout() {
        if (StpUtil.isLogin()) {
            StpUtil.logout();
        }
    }

    public static Mono<TokenInfo> reactiveUser() {
        return ReactiveRequestContextHolder.getExchange().map(SecurityUtil::getToken).onErrorResume(Mono::error).map(StpUtil::getTokenSessionByToken).map(CurrentUserContext::tokenSession);
    }

    private static TokenInfo tokenSession(SaSession tokenSession) {
        TokenInfo model = (TokenInfo)tokenSession.getModel(USER_SESSION_ID, TokenInfo.class);
        if (model == null) {
            throw new TokenException("Token has expired");
        }
        return model;
    }

    public static void user(TokenInfo user) {
        SaSession saSession = StpUtil.getTokenSessionByToken((String)user.getAccessToken());
        saSession.set(USER_SESSION_ID, (Object)user);
    }

    public static TokenInfo refresh(String access_token) {
        StpUtil.checkActivityTimeout();
        StpUtil.updateLastActivityToNow();
        SaSession saSession = StpUtil.getTokenSessionByToken((String)access_token);
        TokenInfo user = (TokenInfo)saSession.getModel(USER_SESSION_ID, TokenInfo.class);
        long timeout = saSession.getTimeout();
        user.setExpiresIn(timeout);
        saSession.set(USER_SESSION_ID, (Object)user);
        return user;
    }
}

