package me.youm.frame.security.utils;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.SaTokenInfo;
import cn.dev33.satoken.stp.StpUtil;
import me.youm.frame.common.entity.TokenInfo;
import me.youm.frame.common.exception.TokenException;

import static me.youm.frame.common.constants.AuthConstant.USER_SESSION_ID;

/**
 * @author youta
 */
public class LoginUtil {

    public static TokenInfo user(){
        SaSession tokenSession;
        try {
            tokenSession = StpUtil.getTokenSession();
        }catch (NotLoginException e){
            throw new TokenException("Token has expired");
        }
        if (tokenSession == null)
            throw new TokenException("Token has expired");

        TokenInfo model = tokenSession.getModel(USER_SESSION_ID, TokenInfo.class);
        if (model == null)
            throw new TokenException("Token has expired");
        return model;
    }

    public static String username(){
        return user().getUsername();
    }

    public static String realName(){
        return user().getRealName();
    }

    public static String userId(){
        return user().getUserId();
    }

    public static void logout() {
        if (StpUtil.isLogin()){
            StpUtil.logout();
        }
    }

    public static SaTokenInfo login(String username) {
        StpUtil.login(username);
        return StpUtil.getTokenInfo();
    }

    public static void user(TokenInfo user) {
        SaSession saSession = StpUtil.getTokenSessionByToken(user.getAccessToken());
        saSession.set(USER_SESSION_ID, user);
    }
}
