/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.security.aspect;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.StpUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import me.youm.frame.common.entity.TokenInfo;
import me.youm.frame.common.enums.CodeEnum;
import me.youm.frame.common.exception.AuthorityException;
import me.youm.frame.common.exception.TokenException;
import me.youm.frame.security.annotation.PreAuth;
import me.youm.frame.security.enums.SuperAdmin;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class PreAuthAspect {
    private static final Logger log = LoggerFactory.getLogger(PreAuthAspect.class);
    private static final String ALL_PERMISSION = "*:*:*";

    @Around(value="@annotation(me.youm.frame.security.annotation.PreAuth)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        PreAuth preAuth = method.getAnnotation(PreAuth.class);
        if (ObjectUtils.isEmpty((Object)preAuth)) {
            return point.proceed();
        }
        if (this.hasPerm(preAuth.value())) {
            return point.proceed();
        }
        throw new AuthorityException(CodeEnum.FORBIDDEN.getMsg());
    }

    public boolean hasPerm(String permission) {
        SaSession tokenSession;
        try {
            tokenSession = StpUtil.getTokenSession();
        }
        catch (NotLoginException ex) {
            throw new TokenException(ex.getMessage());
        }
        TokenInfo currentUser = (TokenInfo)tokenSession.getModel("user", TokenInfo.class);
        if (currentUser == null) {
            return false;
        }
        if (!StringUtils.hasText((String)permission)) {
            return true;
        }
        if (currentUser.getUserName().equalsIgnoreCase(SuperAdmin.ADMIN.getValue())) {
            return true;
        }
        return this.hasPermissions(Arrays.stream(String.valueOf(currentUser.getAuthorities()).split(",")).collect(Collectors.toList()), permission);
    }

    private boolean hasPermissions(Collection<String> authorities, String permission) {
        return authorities.stream().filter(StringUtils::hasText).anyMatch(x -> ALL_PERMISSION.contains((CharSequence)x) || PatternMatchUtils.simpleMatch((String)permission, (String)x));
    }
}

