/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.security.utils;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.SaTokenInfo;
import cn.dev33.satoken.stp.StpUtil;
import me.youm.frame.common.entity.TokenInfo;
import me.youm.frame.common.exception.TokenException;

public class LoginUtil {
    public static TokenInfo user() {
        SaSession tokenSession;
        try {
            tokenSession = StpUtil.getTokenSession();
        }
        catch (NotLoginException e) {
            throw new TokenException("Token has expired");
        }
        if (tokenSession == null) {
            throw new TokenException("Token has expired");
        }
        TokenInfo model = (TokenInfo)tokenSession.getModel("user", TokenInfo.class);
        if (model == null) {
            throw new TokenException("Token has expired");
        }
        return model;
    }

    public static String username() {
        return LoginUtil.user().getUsername();
    }

    public static String realName() {
        return LoginUtil.user().getRealName();
    }

    public static String userId() {
        return LoginUtil.user().getUserId();
    }

    public static void logout() {
        if (StpUtil.isLogin()) {
            StpUtil.logout();
        }
    }

    public static SaTokenInfo login(String username) {
        StpUtil.login((Object)username);
        return StpUtil.getTokenInfo();
    }

    public static void user(TokenInfo user) {
        SaSession saSession = StpUtil.getTokenSessionByToken((String)user.getAccessToken());
        saSession.set("user", (Object)user);
    }
}

