package me.youm.frame.webflux.page;

import com.github.pagehelper.PageInfo;
import me.youm.frame.common.entity.Search;

import java.util.stream.Collectors;

/**
 * @author youta
 */
public class PageUtil {
    public static <T> PageInfo<T> page(Search search, PageInfo<T> info) {
        if (info == null || info.getList().size() == 0) {
            return info;
        }
        return setPage(search, info);
    }

    private static <T> PageInfo<T> setPage(Search search, PageInfo<T> info) {
        info.setPageNum(search.getCurrent());
        info.setPageSize(search.getSize());
        info.setSize(search.getSize());
        info.setStartRow((long) (search.getCurrent() - 1) * search.getSize());
        info.setEndRow((long) search.getCurrent() * search.getSize() - 1);
        int total = (int) info.getTotal();
        info.setPages(total % search.getSize() == 0 ? total / search.getSize() : total / search.getSize() + 1);
        info.setIsFirstPage(search.getCurrent() == 1);
        info.setIsLastPage(search.getCurrent() == info.getPages());
        info.setHasNextPage(search.getCurrent() < info.getPages());
        info.setHasPreviousPage(search.getCurrent() != 1);
        info.setPrePage(info.isHasPreviousPage() ? search.getCurrent() - 1 : 0);
        info.setNextPage(info.isHasNextPage() ? search.getCurrent() + 1 : 0);
        info.setList(info.getList().stream()
                .skip((long) (search.getCurrent() - 1) * search.getSize())
                .limit(search.getSize()).collect(Collectors.toList()));
        return info;
    }
}
