/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.webflux.page;

import com.github.pagehelper.PageInfo;
import java.util.stream.Collectors;
import me.youm.frame.common.entity.Search;

public class PageUtil {
    public static <T> PageInfo<T> page(Search search, PageInfo<T> info) {
        if (info == null || info.getList().size() == 0) {
            return info;
        }
        return PageUtil.setPage(search, info);
    }

    private static <T> PageInfo<T> setPage(Search search, PageInfo<T> info) {
        info.setPageNum(search.getCurrent().intValue());
        info.setPageSize(search.getSize().intValue());
        info.setSize(search.getSize().intValue());
        info.setStartRow((long)(search.getCurrent() - 1) * (long)search.getSize().intValue());
        info.setEndRow((long)search.getCurrent().intValue() * (long)search.getSize().intValue() - 1L);
        int total = (int)info.getTotal();
        info.setPages(total % search.getSize() == 0 ? total / search.getSize() : total / search.getSize() + 1);
        info.setIsFirstPage(search.getCurrent() == 1);
        info.setIsLastPage(search.getCurrent().intValue() == info.getPages());
        info.setHasNextPage(search.getCurrent() < info.getPages());
        info.setHasPreviousPage(search.getCurrent() != 1);
        info.setPrePage(info.isHasPreviousPage() ? search.getCurrent() - 1 : 0);
        info.setNextPage(info.isHasNextPage() ? search.getCurrent() + 1 : 0);
        info.setList(info.getList().stream().skip((long)(search.getCurrent() - 1) * (long)search.getSize().intValue()).limit(search.getSize().intValue()).collect(Collectors.toList()));
        return info;
    }
}

