/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.webflux.filter;

import java.util.ArrayList;
import java.util.Collection;
import me.youm.frame.common.context.ReactiveRequestContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public class ReactorContextWebFilter
implements WebFilter {
    private static final Logger log = LoggerFactory.getLogger(ReactorContextWebFilter.class);

    @NonNull
    public Mono<Void> filter(@NonNull ServerWebExchange exchange, WebFilterChain chain) {
        String requestUrl = exchange.getRequest().getURI().getRawPath();
        StringBuilder beforeReqLog = new StringBuilder(300);
        ArrayList<String> beforeReqArgs = new ArrayList<String>();
        beforeReqLog.append("\n\n================ Shore Request Start  ================\n");
        beforeReqLog.append("===> {}: {}\n");
        String requestMethod = exchange.getRequest().getMethodValue();
        beforeReqArgs.add(requestMethod);
        beforeReqArgs.add(requestUrl);
        HttpHeaders headers = exchange.getRequest().getHeaders();
        headers.forEach((headerName, headerValue) -> {
            beforeReqLog.append("===Headers===  {}: {}\n");
            beforeReqArgs.add((String)headerName);
            beforeReqArgs.add(StringUtils.collectionToCommaDelimitedString((Collection)headerValue));
        });
        beforeReqLog.append("================ Shore Request End =================\n");
        log.debug(beforeReqLog.toString(), beforeReqArgs.toArray());
        return chain.filter(exchange).contextWrite(context -> context.put((Object)ReactiveRequestContextHolder.CONTEXT_KEY, (Object)exchange));
    }
}

