/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.webflux.handler;

import cn.hutool.json.JSONUtil;
import java.nio.charset.StandardCharsets;
import me.youm.frame.common.exception.AuthorityException;
import me.youm.frame.common.exception.IdempotentException;
import me.youm.frame.common.exception.TokenException;
import me.youm.frame.common.model.Result;
import me.youm.frame.common.utils.ResponseUtil;
import me.youm.frame.webflux.handler.ExceptionHandlerAdvice;
import org.reactivestreams.Publisher;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

@Configuration
@Order(value=-2)
public class GlobalErrorHandler
implements ErrorWebExceptionHandler {
    @NonNull
    public Mono<Void> handle(ServerWebExchange serverWebExchange, @NonNull Throwable throwable) {
        ServerHttpResponse response = serverWebExchange.getResponse();
        if (throwable instanceof TokenException) {
            return ResponseUtil.webFluxResponseWriter((ServerHttpResponse)response, (String)"application/json;charset=UTF-8", (HttpStatus)HttpStatus.UNAUTHORIZED, (Object)throwable.getMessage());
        }
        if (throwable instanceof AuthorityException) {
            return ResponseUtil.webFluxResponseWriter((ServerHttpResponse)response, (String)"application/json;charset=UTF-8", (HttpStatus)HttpStatus.FORBIDDEN, (Object)throwable.getMessage());
        }
        response.getHeaders().add("Content-Type", "application/json;charset=UTF-8");
        Result<?> result = ExceptionHandlerAdvice.handle(throwable);
        response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
        if (throwable instanceof ResponseStatusException) {
            response.setStatusCode(((ResponseStatusException)throwable).getStatus());
        }
        if (throwable instanceof IdempotentException) {
            response.setStatusCode(HttpStatus.TOO_MANY_REQUESTS);
        }
        DataBuffer dataBuffer = response.bufferFactory().wrap(JSONUtil.toJsonStr(result).getBytes(StandardCharsets.UTF_8));
        return response.writeWith((Publisher)Mono.just((Object)dataBuffer));
    }
}

