package me.youm.frame.webflux.config;

import io.swagger.models.auth.In;
import me.youm.frame.common.constants.AuthConstant;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.oas.annotations.EnableOpenApi;
import springfox.documentation.service.*;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author youta
 */
@EnableOpenApi
@Configuration
public class SwaggerConfiguration {

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.OAS_30)
                .select()
                .apis(RequestHandlerSelectors.basePackage("tech.shiyunet.payment"))
                .paths(PathSelectors.any())
                .build()
                .globalRequestParameters(this.requestParameterList())
                //添加token
                .securitySchemes(securitySchemes())
                //swagger配置页面访问是否需要传token
                .securityContexts(securityContexts())
                .apiInfo(apiInfo());
    }

    /**
     * 统一设置请求参数
     */
    List<RequestParameter> requestParameterList() {
        RequestParameter headParameter = new RequestParameterBuilder()
                .in(ParameterType.HEADER)
                .name(AuthConstant.HEADER_TOKEN)
                .description("访问凭证")
                .required(false)
                .build();
        return Stream.of(headParameter).collect(Collectors.toList());
    }

    /**
     * 授权信息全局应用
     */
    private List<SecurityContext> securityContexts() {
        return Collections.singletonList(
                SecurityContext.builder()
                        .securityReferences(Collections.singletonList(new SecurityReference(AuthConstant.HEADER_TOKEN, new springfox.documentation.service.AuthorizationScope[]{new AuthorizationScope("global", "")})))
                        .build()
        );
    }
    /**
     * 设置授权信息
     */
    private List<SecurityScheme> securitySchemes() {
        ApiKey apiKey = new ApiKey(AuthConstant.HEADER_TOKEN, AuthConstant.HEADER_TOKEN, In.HEADER.toValue());
        return Collections.singletonList(apiKey);
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                .title("服务端接口文档")
                .description("服务端api接口文档")
                .contact(new Contact("xiyu","https://youm.me","youtaqiu@gmail.com"))
                .termsOfServiceUrl("https://doc.crushes.cn")
                .version("v1")
                .build();
    }

}
