/*
 * Decompiled with CFR 0.152.
 */
package me.youm.frame.webflux.handler;

import cn.hutool.core.util.StrUtil;
import io.netty.channel.ConnectTimeoutException;
import io.sentry.Sentry;
import me.youm.frame.common.enums.CodeEnum;
import me.youm.frame.common.exception.AliOssException;
import me.youm.frame.common.exception.AuthorityException;
import me.youm.frame.common.exception.BusinessException;
import me.youm.frame.common.exception.IdempotentException;
import me.youm.frame.common.exception.PayException;
import me.youm.frame.common.exception.RedissonLockException;
import me.youm.frame.common.exception.RocketMqException;
import me.youm.frame.common.exception.TokenException;
import me.youm.frame.common.model.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.server.ResponseStatusException;

public class ExceptionHandlerAdvice {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlerAdvice.class);

    public static Result<?> handle(ResponseStatusException ex) {
        if (ex instanceof WebExchangeBindException) {
            WebExchangeBindException e = (WebExchangeBindException)ex;
            return ExceptionHandlerAdvice.handle(e);
        }
        log.error("response status exception", (Throwable)ex);
        if (StrUtil.contains((CharSequence)ex.getMessage(), (CharSequence)HttpStatus.NOT_FOUND.toString())) {
            return Result.error((Integer)CodeEnum.NOT_FOUND.getCode(), (String)"\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
        if (StrUtil.contains((CharSequence)ex.getMessage(), (CharSequence)HttpStatus.METHOD_NOT_ALLOWED.toString())) {
            return Result.error((Integer)CodeEnum.METHOD_NOT_ALLOWED.getCode(), (String)"\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u6b63\u786e");
        }
        if (StrUtil.contains((CharSequence)ex.getMessage(), (CharSequence)HttpStatus.UNSUPPORTED_MEDIA_TYPE.toString())) {
            return Result.error((Integer)HttpStatus.UNSUPPORTED_MEDIA_TYPE.value(), (String)"\u4e0d\u652f\u6301\u7684\u5a92\u4f53\u7c7b\u578b");
        }
        if (StrUtil.contains((CharSequence)ex.getMessage(), (CharSequence)HttpStatus.BAD_REQUEST.toString())) {
            if (StringUtils.hasText((String)ex.getReason()) && ex.getReason().split(":").length > 0 && ex.getReason().split(":")[0] != null) {
                return Result.error((Integer)CodeEnum.BAD_REQUEST.getCode(), (String)ex.getReason().split(":")[0]);
            }
            return Result.error((Integer)CodeEnum.BAD_REQUEST.getCode(), (String)"\u53c2\u6570\u9519\u8bef");
        }
        return Result.error();
    }

    public static Result<?> handle(ConnectTimeoutException ex) {
        log.error("connect timeout exception", (Throwable)ex);
        return Result.error();
    }

    public static Result<?> handle(WebExchangeBindException ex) {
        log.error("param bind exception", (Throwable)ex);
        BindingResult bindingResult = ex.getBindingResult();
        StringBuilder errorMessage = new StringBuilder("\u53c2\u6570\u6821\u9a8c\u5931\u8d25:");
        for (FieldError fieldError : bindingResult.getFieldErrors()) {
            errorMessage.append("[").append(fieldError.getField()).append("]").append(":").append(fieldError.getDefaultMessage()).append(";");
        }
        return Result.error((Integer)CodeEnum.BAD_REQUEST.getCode(), (String)errorMessage.toString());
    }

    public static Result<?> handle(BusinessException ex) {
        log.error("business exception", (Throwable)ex);
        return Result.error((Integer)ex.getCode(), (String)ex.getMsg());
    }

    public static Result<?> handle(AliOssException ex) {
        log.error("ali oss exception", (Throwable)ex);
        return Result.error((Integer)ex.getCode(), (String)ex.getMsg());
    }

    public static Result<?> handle(PayException ex) {
        log.error("pay exception", (Throwable)ex);
        return Result.error((Integer)ex.getCode(), (String)ex.getMsg());
    }

    public static Result<?> handle(RocketMqException ex) {
        log.error("rocket exception", (Throwable)ex);
        return Result.error((Integer)ex.getCode(), (String)ex.getMsg());
    }

    public static Result<?> handle(RuntimeException ex) {
        log.error("runtime exception", (Throwable)ex);
        return Result.error();
    }

    public static Result<?> handle(IdempotentException ex) {
        log.error("idempotent exception", (Throwable)ex);
        return Result.error((Integer)HttpStatus.TOO_MANY_REQUESTS.value(), (String)ex.getMessage());
    }

    public Result<?> handleException(RedissonLockException ex) {
        log.error("redisson lock error", (Throwable)ex);
        return Result.error((String)"\u8bf7\u6c42\u8fc7\u5feb");
    }

    public static Result<?> handle(TokenException ex) {
        return Result.error((Integer)HttpStatus.UNAUTHORIZED.value(), (String)ex.getMessage());
    }

    public static Result<?> handle(AuthorityException ex) {
        return Result.error((Integer)HttpStatus.FORBIDDEN.value(), (String)ex.getMessage());
    }

    public static Result<?> handle(Exception ex) {
        log.error("exception", (Throwable)ex);
        return Result.error();
    }

    public static Result<?> handle(Throwable throwable) {
        Sentry.captureException((Throwable)throwable);
        Result<?> result = Result.error();
        if (throwable instanceof ResponseStatusException) {
            result = ExceptionHandlerAdvice.handle((ResponseStatusException)throwable);
        } else if (throwable instanceof ConnectTimeoutException) {
            result = ExceptionHandlerAdvice.handle((ConnectTimeoutException)throwable);
        } else if (throwable instanceof PayException) {
            result = ExceptionHandlerAdvice.handle((PayException)throwable);
        } else if (throwable instanceof RocketMqException) {
            result = ExceptionHandlerAdvice.handle((RocketMqException)throwable);
        } else if (throwable instanceof IdempotentException) {
            result = ExceptionHandlerAdvice.handle((IdempotentException)throwable);
        } else if (throwable instanceof RedissonLockException) {
            result = ExceptionHandlerAdvice.handle((RuntimeException)((RedissonLockException)throwable));
        } else if (throwable instanceof TokenException) {
            result = ExceptionHandlerAdvice.handle((TokenException)throwable);
        } else if (throwable instanceof AuthorityException) {
            result = ExceptionHandlerAdvice.handle((AuthorityException)throwable);
        } else if (throwable instanceof BusinessException) {
            result = ExceptionHandlerAdvice.handle((BusinessException)throwable);
        } else if (throwable instanceof AliOssException) {
            result = ExceptionHandlerAdvice.handle((AliOssException)throwable);
        } else if (throwable instanceof RuntimeException) {
            result = ExceptionHandlerAdvice.handle((RuntimeException)throwable);
        } else if (throwable instanceof Exception) {
            result = ExceptionHandlerAdvice.handle((Exception)throwable);
        }
        return result;
    }
}

