package com.zing.zalo.zbrowser.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
    Created by hoangdv4
    Document: https://docs.zalo.services/display/ZAP/Mini+Program+Data+Storage
 */
public class MiniProgramDataStorageManager {

    private static MiniProgramDataStorageManager miniProgramDataStorageManager;
    private static Map<String, MiniProgramDataStorage> storageMap;
    private String diskStorageDirectory;
    private int STORAGE_SIZE = 1024*1024*5; // 5MB.
    private int EXPIRE_TIME = 7889400; // 3 Months.

    private MiniProgramDataStorageManager(){}

    public static MiniProgramDataStorageManager getInstance(String diskStorageDirectory){
        if(miniProgramDataStorageManager == null){
            miniProgramDataStorageManager = new MiniProgramDataStorageManager();
            storageMap = new HashMap<>();
        }
        if(diskStorageDirectory != null){
            miniProgramDataStorageManager.diskStorageDirectory = diskStorageDirectory;
        }
        return miniProgramDataStorageManager;
    }

    public synchronized void put (String appId, Map<String, String> data){
        MiniProgramDataStorage storage = getStorage(appId);
        for(Map.Entry<String, String> entry : data.entrySet()){
            storage.put(entry.getKey(), entry.getValue(),false);
        }
        storage.putDataToDiskCache();
    }

    public synchronized boolean put (String appId, String key, String value){
        return getStorage(appId).put(key, value);
    }

    public synchronized Map<String, String> get(String appId, List<String> listKey){
        Map<String, String> respond = new HashMap<>();
        MiniProgramDataStorage storage = getStorage(appId);
        for(String key : listKey){
            String value = storage.get(key);
            respond.put(key, value);
        }
        return respond;
    }

    public synchronized void remove(String appId, List<String> listKey){
        MiniProgramDataStorage storage = getStorage(appId);
        for(String key : listKey){
            storage.remove(key, false);
        }
        storage.putDataToDiskCache();
    }

    public synchronized void remove(String appId, String key){
        getStorage(appId).remove(key);
    }

    public synchronized String get(String appId, String key){
        MiniProgramDataStorage storage = getStorage(appId);
        if(storage != null){
            return getStorage(appId).get(key);
        }
        return null;
    }

    public synchronized int getSize(String appId){
        return getStorage(appId).getSize();
    }

    public synchronized void clear(String appId){
        getStorage(appId).clear();
    }

    private MiniProgramDataStorage getStorage(String appId){
        if(storageMap.containsKey(appId)){
            return storageMap.get(appId);
        }else{
            MiniProgramDataStorage miniProgramDataStorage = new MiniProgramDataStorage(
                    diskStorageDirectory,
                    appId,
                    STORAGE_SIZE,
                    EXPIRE_TIME);
            storageMap.put(appId, miniProgramDataStorage);
            return miniProgramDataStorage;
        }
    }


}
