package com.zing.zalo.zbrowser.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
    Created by hoangdv4
    Document: https://docs.zalo.services/display/ZAP/Mini+Program+Data+Storage
 */
public class MiniProgramDataStorageManager {

    private static MiniProgramDataStorageManager miniProgramDataStorageManager;
    private static Map<String, MiniProgramDataStorage> storageMap;
    private String diskStorageDirectory;
    private int STORAGE_SIZE = 80; // 5MB.
    private int EXPIRE_TIME = 7889400; // 3 Months.

    private MiniProgramDataStorageManager(){}

    public static MiniProgramDataStorageManager getInstance(String diskStorageDirectory){
        if(miniProgramDataStorageManager == null){
            miniProgramDataStorageManager = new MiniProgramDataStorageManager();
            storageMap = new HashMap<>();
        }
        if(diskStorageDirectory != null){
            miniProgramDataStorageManager.diskStorageDirectory = diskStorageDirectory;
        }
        return miniProgramDataStorageManager;
    }

    public synchronized List<String> put (String appId, Map<String, String> data){
        MiniProgramDataStorage storage = getStorage(appId);
        ArrayList<String> errorlist = new ArrayList<>();
        for(Map.Entry<String, String> entry : data.entrySet()){
            boolean isSuccess = storage.put(entry.getKey(), entry.getValue());
            if(!isSuccess){
                errorlist.add(entry.getKey());
            }
        }
        return errorlist;
    }

    public synchronized boolean put (String appId, String key, String value){
        return getStorage(appId).put(key, value);
    }

    public synchronized Map<String, String> get(String appId, List<String> listKey){
        Map<String, String> respond = new HashMap<>();
        MiniProgramDataStorage storage = getStorage(appId);
        for(String key : listKey){
            String value = storage.get(key);
            respond.put(key, value);
        }
        return respond;
    }

    public synchronized List<String> remove(String appId, List<String> listKey){
        MiniProgramDataStorage storage = getStorage(appId);
        ArrayList<String> errorlist = new ArrayList<>();
        for(String key : listKey){
            boolean isSuccess = storage.delete(key);
            if(!isSuccess){
                errorlist.add(key);
            }
        }
        return errorlist;
    }

    public synchronized boolean remove(String appId, String key){
        if(appId != null && key != null) {
            return getStorage(appId).delete(key);
        }
        return false;
    }

    public synchronized String get(String appId, String key){
        MiniProgramDataStorage storage = getStorage(appId);
        if(storage != null){
            return getStorage(appId).get(key);
        }
        return null;
    }

    public synchronized long getSize(String appId){
        if(appId != null) {
            return getStorage(appId).getSize();
        }
        return -1;
    }

    public synchronized void clear(String appId){
        if(appId != null) {
            getStorage(appId).clear();
        }
    }

    public synchronized void close(){
        for(Map.Entry<String, MiniProgramDataStorage> entry : storageMap.entrySet()) {
            entry.getValue().close();
        }
    }

    public synchronized void close(String appId){
        if(appId != null) {
            getStorage(appId).close();
        }
    }

    public synchronized void reload(){
        for(Map.Entry<String, MiniProgramDataStorage> entry : storageMap.entrySet()) {
            entry.getValue().reloadBD();
        }
    }

    public synchronized void reload(String appId){
        if(appId != null){
            getStorage(appId).reloadBD();
        }
    }

    public Map<String, String> getAll(String appId){
        if(appId != null) {
            return getStorage(appId).getAll();
        }
        return new HashMap<>();
    }


    private MiniProgramDataStorage getStorage(String appId){
        if(storageMap.containsKey(appId)){
            return storageMap.get(appId);
        }else{
            MiniProgramDataStorage miniProgramDataStorage = new MiniProgramDataStorage(
                    diskStorageDirectory,
                    appId,
                    STORAGE_SIZE,
                    EXPIRE_TIME);
            storageMap.put(appId, miniProgramDataStorage);
            return miniProgramDataStorage;
        }
    }


}
