/*
 * Copyright (c) 2012-2018 by Zalo Group.
 * All Rights Reserved.
 */
package com.zing.zalo.zbrowser.downloader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

/**
 *
 * @author datbt
 */
public class ChunkedResponse {

	private ByteBuffer bufferChunked;

	public byte[] parseChunked(byte[] in) throws IOException {
		if (bufferChunked != null && bufferChunked.hasRemaining()) {
			ByteBuffer tmp = ByteBuffer.allocate(bufferChunked.remaining() + in.length);
			tmp.put(bufferChunked);
			tmp.put(in);
			tmp.flip();
			in = tmp.array();
		}

		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		StringBuilder chunkLengthStr = new StringBuilder();
		int startChunkPos = 0;
		int currentPos = 0;
		while (currentPos < in.length) {
			if (in[currentPos] != HTTP.CR) {
				chunkLengthStr.append((char) in[currentPos]);
				++currentPos;
				continue;
			}
			if (currentPos + 1 == in.length) {
				bufferChunked = ByteBuffer.wrap(in, startChunkPos, in.length - startChunkPos);
				break;
			}
			if (in[currentPos + 1] != HTTP.LF) {
				throw new IOException("CRLF expected at the end of chunk header");
			}
			int chunkLength;
			try {
				chunkLength = Integer.parseInt(chunkLengthStr.toString(), 16);
			} catch (NumberFormatException e) {
				throw new IOException("Invalid chunk length: " + chunkLengthStr.toString());
			}
			chunkLengthStr = new StringBuilder();
			currentPos += 2; // jump to LF then jump to first pos of chunk data
			if (chunkLength > 0) {
				if (currentPos + chunkLength + 2 > in.length) {
					bufferChunked = ByteBuffer.wrap(in, startChunkPos, in.length - startChunkPos);
					break;
				} else {
					baos.write(in, currentPos, chunkLength);
					currentPos += chunkLength;
					if (in[currentPos] != HTTP.CR || in[currentPos + 1] != HTTP.LF) {
						throw new IOException("CRLF expected at the end of chunk data");
					}
					currentPos += 2;
					startChunkPos = currentPos;
				}
			} else if (chunkLength == 0) { //eof
				if (currentPos + 2 > in.length || baos.size() > 0) {
					bufferChunked = ByteBuffer.wrap(in, startChunkPos, in.length - startChunkPos);
					break;
				}
				if (currentPos + 2 != in.length || in[currentPos] != HTTP.CR || in[currentPos + 1] != HTTP.LF) {
					throw new IOException("Invalid stream footer");
				}
				return new byte[]{};//return empty as eof
			} else {
				throw new IOException("Negative chunk length: " + chunkLength);
			}
		}

		if (baos.size() > 0) {
			return baos.toByteArray();
		}

		return null;
	}
}
